//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// LUNA* の RAM のうち 16MB に満たないメモリブロックを担当する人
//

#pragma once

#include "device.h"

class MainRAMDevice;

class PartialRAMDevice : public IODevice
{
	using inherited = IODevice;
 public:
	PartialRAMDevice();
	~PartialRAMDevice() override;

	bool Init() override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr addr, uint32 data) override;
	busdata Peek1(uint32 addr) override;
	bool Poke1(uint32 addr, uint32 data) override;

 private:
	inline IODevice *SearchDevice(uint32 addr) const;

	uint32 ram_size {};

	MainRAMDevice *ramdev {};
	IODevice *nopdev {};
};

static inline PartialRAMDevice *GetPartialRAMDevice() {
	return Object::GetObject<PartialRAMDevice>(OBJ_PARTIAL_RAM);
}
