//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// プリンタポート
//

#include "printer.h"
#include "event.h"

// InsideOut p.135
static const busdata wait = busdata::Wait(7 * 40_nsec);

// コンストラクタ
PrinterDevice::PrinterDevice()
	: inherited(OBJ_PRINTER)
{
}

// デストラクタ
PrinterDevice::~PrinterDevice()
{
}

busdata
PrinterDevice::ReadPort(uint32 offset)
{
	// 書き込み専用
	busdata data = BusData::BusErr;
	data |= wait;
	return data;
}

busdata
PrinterDevice::WritePort(uint32 offset, uint32 data)
{
	busdata r;

	switch (offset) {
	 case 0:
		// データ書き込み
		putlog(0, "Write Data (NOT IMPLEMENTED)");
		r.SetBusErr();
		break;
	 case 1:
		// ストローブ書き込み
		putlog(0, "Write Strobe (NOT IMPLEMENTED)");
		r = 0;
		break;
	 default:
		break;
	}

	r |= wait;
	r |= BusData::Size1;
	return r;
}

busdata
PrinterDevice::PeekPort(uint32 offset)
{
	// XXX
	return 0xff;
}

bool
PrinterDevice::PokePort(uint32 offset, uint32 data)
{
	return false;
}
