//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// プリンタポート
//

#pragma once

#include "device.h"

class PrinterDevice : public IODevice
{
	using inherited = IODevice;

	static const uint32 baseaddr = 0xe8c000;

 public:
	PrinterDevice();
	~PrinterDevice() override;

 protected:
	// BusIO インタフェース
	// XXX まだ調べてない
	static const uint32 NPORT = 2;
	busdata ReadPort(uint32 offset);
	busdata WritePort(uint32 offset, uint32 data);
	busdata PeekPort(uint32 offset);
	bool PokePort(uint32 offset, uint32 data);
};
