//
// nono
// Copyright (C) 2024 nono project
// Licensed under nono-license.txt
//

//
// ROM エミュレーションデバイスの基本クラス
//

// IODevice
//  |
//  +- ROMDevice (LoadROM()、ウェイト、マスク等を持つ)
//  |   +- PROMDevice    (LUNA* の PROM)
//  |   +- IPLROM1Device (X680x0 の IPLROM 後半)
//  |   +- IPLROM2Device (X680x0 の IPLROM 前半)
//  |   +- CGROMDevice   (X680x0 の CGROM)
//  |   |
//  |   | +--------------+
//  |   +-| ROMEmuDevice | (ROM エミュレーションの共通部分)
//  |     +--------------+
//  |       |
//  |       +- LunaPROMEmuDevice (LUNA PROM エミュレーションの共通部分)
//  |       |   +- Luna1PROMEmuDevice   (LUNA-I の PROM エミュレーション)
//  |       |   +- Luna88kPROMEmuDevice (LUNA-88K の PROM エミュレーション)
//  |       +- NewsROMEmuDevice    (NEWS の ROM エミュレーション)
//  |       +- ROM30EmuDevice      (X68030 の ROM30 エミュレーション)
//  |       +- Virt68kROMEmuDevice (virt-m68k の IPLROM 相当の何か)
//  |
//  +- PROM0Device   (LUNA* のブートページ切り替え用プロキシ)
//  +- IPLROM0Device (X680x0 のブートページ切り替え用プロキシ)

#include "romemu.h"

// コンストラクタ
ROMEmuDevice::ROMEmuDevice(uint objid_)
	: inherited(objid_)
{
}

// デストラクタ
ROMEmuDevice::~ROMEmuDevice()
{
}

busdata
ROMEmuDevice::Read(busaddr addr)
{
	uint64 romdata;

	// ROMIO が反応すればそっちを返す。そうでなければ ROM の内容を返す。
	romdata = ReadROMIO(addr);
	if ((int64)romdata >= 0) {
		busdata data = romdata;
		data |= BusData::Size4;
		return data;
	} else {
		return inherited::Read(addr);
	}
}

busdata
ROMEmuDevice::Write(busaddr addr, uint32 data)
{
	// ROMIO が反応するかどうか。どちらにしても規定の応答を返す。
	if (WriteROMIO(addr, data) == true) {
		busdata r = write_op;
		r |= BusData::Size4;
		return r;
	} else {
		return inherited::Write(addr, data);
	}
}

// 必要なら継承側でオーバーライドする。
uint64
ROMEmuDevice::ReadROMIO(busaddr addr)
{
	return (uint64)-1;
}

// 必要なら継承側でオーバーライドする。
bool
ROMEmuDevice::WriteROMIO(busaddr addr, uint32 data)
{
	return false;
}

// Peek は未対応。
