//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// NEWS の ROM エミュレーション (-X のみ対応)
//

#pragma once

#include "romemu.h"

class MainRAMDevice;

class NewsROMEmuDevice : public ROMEmuDevice
{
	using inherited = ROMEmuDevice;

 protected:
	// このデバイス先頭アドレス
	static const uint32 baseaddr		= 0xf8000000;

	// 謎の I/O 空間
	static const uint32 ROMIO_BASE		= 0xf8010000;
	static const uint32 ROMIO_INIT		= (ROMIO_BASE + 0);
	static const uint32 ROMIO_SYS		= (ROMIO_BASE + 4);

	// NEWS の ROM サービスコール?
	static const uint32 SYS_reboot	= 0;
	static const uint32 SYS_exit	= 1;
	static const uint32 SYS_read	= 3;
	static const uint32 SYS_write	= 4;

 public:
	NewsROMEmuDevice();
	~NewsROMEmuDevice() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

 private:
	uint64 ReadROMIO(busaddr addr) override;

	uint32 ROM_Init();
	uint32 ROM_Sys();

	MainRAMDevice *mainram {};
};
