//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// SCSI (定数等)
//

#include "scsi.h"

// フェーズ文字列を返す
/*static*/ const char *
SCSI::GetPhaseName(Phase phase)
{
	switch (phase) {
	 case BusFree:		return "BusFree";
	 case Arbitration:	return "Arbitration";
	 case Selection:	return "Selection";
	 case Reselection:	return "Reselection";
	 case Transfer:		return "Transfer";
	 default:			return "Phase?";
	}
}

// 情報転送フェーズ文字列を返す
/*static*/ const char *
SCSI::GetXferPhaseName(XferPhase xfer)
{
	switch (xfer) {
	 case DataOut:	return "DataOut";
	 case DataIn:	return "DataIn";
	 case Command:	return "Command";
	 case Status:	return "Status";
	 case MsgOut:	return "MsgOut";
	 case MsgIn:	return "MsgIn";
	 case End:		return "End";
	 default:		return "XferPhase?";
	}
}

// デバイス種別文字列を返す
/*static*/ const char *
SCSI::GetDevTypeName(DevType type)
{
	switch (type) {
	 case DevType::None:		return "None";
	 case DevType::Initiator:	return "Initiator";
	 case DevType::HD:			return "HD";
	 case DevType::CD:			return "CD";
	 case DevType::MO:			return "MO";
	 default:					return "DevType?";
	}
}

// cmd に対応するコマンド名を返す。
/*static*/ const char *
SCSI::GetCommandName(uint8 cmd)
{
	if (cmd < commandname.size()) {
		return commandname[cmd];
	} else {
		return NULL;
	}
}

// コマンド名
/*static*/ const std::vector<const char *>
SCSI::commandname =
{
	"TestUnitReady",		// 00
	"RezeroUnit",			// 01
	NULL,					// 02
	"RequestSense",			// 03
	"FormatUnit",			// 04
	NULL,					// 05
	NULL,					// 06
	"ReassignBlocks",		// 07
	"Read(6)",				// 08
	NULL,					// 09
	"Write(6)",				// 0a
	"Seek(6)",				// 0b
	NULL,					// 0c
	NULL,					// 0d
	NULL,					// 0e
	NULL,					// 0f

	NULL,					// 10
	NULL,					// 11
	"Inquiry",				// 12
	NULL,					// 13
	NULL,					// 14
	"ModeSelect(6)",		// 15
	"Reserve",				// 16
	"Release",				// 17
	"Copy",					// 18
	NULL,					// 19
	"ModeSense(6)",			// 1a
	"StartStopUnit",		// 1b
	"ReceiveDiagnosticResults",		// 1c
	"SendDiagnostic",		// 1d
	"PreventAllowMediumRemoval",	// 1e
	NULL,					// 1f

	NULL,					// 20
	NULL,					// 21
	NULL,					// 22
	"ReadFormatCapacities",	// 23
	NULL,					// 24
	"ReadCapacity",			// 25
	NULL,					// 26
	NULL,					// 27
	"Read(10)",				// 28
	NULL,					// 29
	"Write(10)",			// 2a
	"Seek(10)",				// 2b
	NULL,					// 2c
	NULL,					// 2d
	"WriteAndVerify(10)",	// 2e
	"Verify(10)",			// 2f

	"SearchDataHigh(10)",	// 30
	"SearchDataEqual(10)",	// 31
	"SearchDataLow(10)",	// 32
	"SetLimits",			// 33
	"PreFetch",				// 34
	"SynchronizeCache",		// 35
	"LockUnlockCache",		// 36
	"ReadDefectData(10)",	// 37
	NULL,					// 38
	"Compare",				// 39
	"CopyAndVerify",		// 3a
	"WriteBuffer",			// 3b
	"ReadBuffer",			// 3c
	NULL,					// 3d
	"ReadLong",				// 3e
	"WriteLong",			// 3f

	"ChangeDefinition",		// 40
	"WriteSame",			// 41
	NULL,					// 42
	"ReadTOC",				// 43
	"ReadHeader",			// 44
	NULL,					// 45
	NULL,					// 46
	NULL,					// 47
	NULL,					// 48
	NULL,					// 49
	NULL,					// 4a
	NULL,					// 4b
	"LogSelect",			// 4c
	"LogSense",				// 4d
	NULL,					// 4e
	NULL,					// 4f
	NULL,					// 50
	"ReadDiscInformation",	// 51
	NULL,					// 52
	NULL,					// 53
	NULL,					// 54
	"ModeSelect(10)",		// 55
	NULL,					// 56
	NULL,					// 57
	NULL,					// 58
	NULL,					// 59
	"ModeSense(10)",		// 5a
};

// センスキーとその名前を表示用に整形したものを返す
/*static*/ std::string
SCSI::GetSenseKeyDisp(uint8 key)
{
	if (__predict_true(key < sensekeyname.size())) {
		return string_format("%s($%x)",sensekeyname[key], key);
	} else {
		return string_format("$%x", key);
	}
}

/*static*/ const std::vector<const char *>
SCSI::sensekeyname =
{
	"NoSense",			// 0x0
	"RecoveredError",	// 0x1
	"NotReady",			// 0x2
	"MediumError",		// 0x3
	"HardwareError",	// 0x4
	"IllegalRequest",	// 0x5
	"UnitAttention",	// 0x6
	"DataProtect",		// 0x7
	"BlankCheck",		// 0x8
	"VendorSpecific",	// 0x9
	"CopyAborted",		// 0xa
	"AbortedCommand",	// 0xb
	"Equal",			// 0xc
	"VolumeOverflow",	// 0xd
	"Miscompare",		// 0xe
	"Reserved",			// 0xf
};

// Mode Select/Sense のページ番号とページ名を表示用に整形したものを返す
/*static*/ std::string
SCSI::GetModePageDisp(uint8 page)
{
	const char *name;

	if (__predict_true(page < modepagename.size())) {
		name = modepagename[page];
	} else if (page == 0x3f) {
		name = "AllPages";
	} else {
		return string_format("$%02x", page);
	}

	return string_format("$%02x(%s)", page, name);
}

/*static*/ const std::vector<const char *>
SCSI::modepagename =
{
	"VendorSpecific",			// 00
	"ReadWriteErrorRecovery",	// 01
	"DisconnectReconnect",		// 02
	"FormatDevice",				// 03
	"RigidDiskGeometry",		// 04
	"FlexibleDisk",				// 05
	"OpticalMemory",			// 06
	"VerifyErrorRecovery",		// 07
	"CachingPage",				// 08
	"PeripheralDevice",			// 09
	"ControlMode",				// 0a
	"MediumTypeSupported",		// 0b
	"NotchAndPartition",		// 0c
	"CDROM",					// 0d
	"CDROMAudioControl",		// 0e
};
