//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// UI スレッドへのメッセージ機構
//

#pragma once

#include "fixedqueue.h"
#include <functional>

class UIMessage
{
 public:
	// メッセージ ID
	enum ID {
		NONE = 0,

		// アプリケーションを終了する
		APPEXIT,

		// MPU がホールト状態になった
		HALT,

		// SCSI (各 ID) のメディア状態が変わった (Load/Unload)
		SCSI_MEDIA_CHANGE,

		// SCSI メディアの挿入に失敗した
		SCSI_MEDIA_FAILED,

		// FDD (各 ID) のメディア状態が変わった (Load/Unload)
		FDD_MEDIA_CHANGE,

		// FDD メディアの挿入に失敗した
		FDD_MEDIA_FAILED,

		// キー入力状態が変わった
		KEYBOARD,

		// LCD 状態が変わった
		LCD,

		// 画面を更新した
		RENDER,

		// パレットが変更になった
		PALETTE,

		// LED 状態が変わった
		LED,

		ID_MAX,
	};

	using Queue = FixedQueue<UIMessage, 16>;

 public:
	UIMessage();
	UIMessage(ID id_, int arg_);

	ID GetID() const { return id; }
	int GetArg() const { return arg; }

	// メッセージ処理関数をアタッチ
	static void Attach(const std::function<void(Queue&)>& process_);

	// 新しい UIMessage を生成して投函
	static void Post(ID id);
	// 新しい UIMessage を生成して投函(argあり)
	static void Post(ID id, int arg);

 protected:
	// 自身を投函
	void Post();

 private:
	ID id {};
	int arg {};

	static Queue queue;

	// メッセージ処理コールバック
	static std::function<void(Queue&)> process;
};
