//
// nono
// Copyright (C) 2024 nono project
// Licensed under nono-license.txt
//

//
// VirtIO ネットワークデバイス
//

#pragma once

#include "virtio_base.h"
#include "event.h"
#include "hostnet.h"
#include "message.h"

class VirtIONetDevice : public VirtIODevice, public IHWAddrFilter
{
	using inherited = VirtIODevice;
 public:
	explicit VirtIONetDevice(uint slot_);
	~VirtIONetDevice() override;

	bool Create() override;
	bool Init() override;

	int HWAddrFilter(const MacAddr& dstaddr) const override;

 private:
	DECLARE_MONITOR_CALLBACK(MonitorUpdate);

	void QueueReadyChanged(VirtQueue *) override;
	void ProcessDesc(VirtIOReq&) override;

	const char *GetFeatureName(uint feature) const override;

	// 受信
	void HostRxCallback();
	void RxMessage(MessageID, uint32);
	void RxEvent(Event&);
	void Rx(VirtQueue *);

	MacAddr macaddr {};
	std::string macaddr_str {};

	NetPacket rx_packet {};

	std::unique_ptr<HostNetDevice> hostnet /*{}*/;

	Event event { this };
};
