//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// VM (基本クラス)
//

#pragma once

#include "device.h"

class VM
{
 protected:
	explicit VM(const char *vmname_);
 public:
	enum CreationPhase : bool {
		First = false,
		Second = true,
	};

 public:
	virtual ~VM();

	// 明示的な後始末
	void Dispose();

	// 動的なコンストラクション
	bool Create(CreationPhase);

	// 初期化
	bool Init();

	// スレッド開始
	bool StartThread();

	// 設定の適用
	bool Apply();

	// VM 名取得 (ウィンドウタイトル用)
	const char *GetVMName() const { return vmname; }

 protected:
	std::unique_ptr<Device> pDebugger {};
	std::unique_ptr<Device> pKeyboard {};
	std::unique_ptr<Device> pMainbus {};
	std::unique_ptr<Device> pMPU {};
	std::unique_ptr<Device> pNMI {};
	std::unique_ptr<Device> pPower {};
	std::unique_ptr<Device> pRenderer {};
	std::unique_ptr<Device> pScheduler {};
	std::unique_ptr<Device> pSignalThread {};
	std::unique_ptr<Device> pSyncer {};

 private:
	const char *vmname {};	// VM 機種名(表示名)
};
