//
// nono
// Copyright (C) 2024 nono project
// Licensed under nono-license.txt
//

//
// VM (virt-m68k)
//

#include "vm_virt68k.h"
#include "config.h"
#include "console.h"
#include "mainbus_virt68k.h"
#include "mpu680x0.h"
#include "power.h"
#include "renderer.h"

// コンストラクタ
VM_Virt68k::VM_Virt68k()
	: inherited("virt-m68k")
{
	// 機種固有パラメータ
	// 実時間に同期したほうが便利。
	gConfig->SetDefault("clock-sync", "real");
	gConfig->SetDefault("hostcom-driver", "cons");
	gConfig->SetDefault("mpu-type", "68030");
	gConfig->SetDefault("mpu-clock", 25);
	// RAM 初期値。適当。
	gConfig->SetDefault("ram-size", 128);

	// デバイス
	NEWDV(Power, new PowerDevice());
	NEWDV(MPU, NewMPU680x0Device());
	NEWDV(Mainbus, new Virt68kMainbus());
	NEWDV(Console, new ConsoleDevice());
	NEWDV(Keyboard, new ConsoleKeyboard());
	NEWDV(Renderer, new ConsoleRenderer());

	// バーストアクセス有効にする
	auto mpu680x0 = GetMPU680x0Device(pMPU.get());
	if (mpu680x0) {
		mpu680x0->EnableBurstAccess(true);
	}
}

// デストラクタ
VM_Virt68k::~VM_Virt68k()
{
}
