//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// バックバッファが BitmapRGBX なパネル
//

#pragma once

#include "wxnono.h"
#include "bitmap.h"

class WXBitmapPanel : public wxPanel
{
	using inherited = wxPanel;
 public:
	WXBitmapPanel(wxWindow *parent,
		const wxPoint& position = wxDefaultPosition,
		const wxSize& size = wxDefaultSize,
		long style = wxTAB_TRAVERSAL);
	WXBitmapPanel(wxWindow *parent, wxWindowID id,
		const wxPoint& position = wxDefaultPosition,
		const wxSize& size = wxDefaultSize,
		long style = wxTAB_TRAVERSAL);
	virtual ~WXBitmapPanel() override;

	// 背景色を設定する
	void SetBitmapBGColor(Color c);

	// 背景色で塗りつぶす
	void Fill();

	// サイズ固定。
	// Bitmap クラスは範囲外への描画を自動クリップする機能を持っていないため、
	// ソフトウェアキーボードウィンドウが実画面サイズを超えるようなケースで
	// あっても、バックバッファは表示ウィンドウサイズと同じにするのではなく
	// 常に指定の大きさで存在していてほしい。という時に指定する。
	// バックバッファより小さいウィンドウへの描画は問題なく行えるっぽい?。
	// 一方、自前スクロールバーのように、制約なく指定サイズを受け入れる場合は
	// (0, 0) を指定する (デフォルト)。
	void SetFixedSize(const wxSize& size);

 protected:
	void OnSize(wxSizeEvent&);
	void OnPaint(wxPaintEvent&);

	virtual void Draw();

	BitmapRGBX bitmap {};

	// 固定サイズ指定
	wxSize fixedsize {};

 private:
	BitmapRGB bitmap24 {};

	Color bitmap_bgcolor;

	wxDECLARE_EVENT_TABLE();
};
