//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// メモリダンプウィンドウ
//

#pragma once

#include "wxsubwindow.h"
#include "wxbutton.h"
#include "wxmonitor.h"
#include "memdump.h"
#include <array>

class WXMemdumpWindow : public WXSubWindow
{
	using inherited = WXSubWindow;
 public:
	WXMemdumpWindow(wxWindow *parent, int monid);
	virtual ~WXMemdumpWindow() override;

	bool Layout() override;
	void FontChanged() override;

 private:
	// テキスト入力イベント
	void OnTextEnter(wxCommandEvent& event);

	// ボタンイベント
	void OnPrevLine(wxCommandEvent& event);
	void OnPrevPage(wxCommandEvent& event);
	void OnNextLine(wxCommandEvent& event);
	void OnNextPage(wxCommandEvent& event);

	// 表示フォーマット変更イベント
	void OnFormat(wxCommandEvent& event);
	void DoFormat(Memdump::Format fmt_);

	// マウスイベント
	void OnMouseWheel(wxMouseEvent& event);
	void OnDClick(wxMouseEvent& event);

	uint64 GetAddrAtHexdump(int x, int y, int len);
	uint64 GetAddrAtPageShort(int x, int y);
	uint64 GetAddrAtDisasm(int x, int y, int instlen);

	// アドレス欄を更新
	void UpdateAddr();

	// フォーマット番号とセレクション番号の相互変換
	Memdump::Format Selection2Format(int idx);
	int Format2Selection(Memdump::Format fmt_);
	wxString Format2String(Memdump::Format fmt_);

	// コントロール
	wxTextCtrl *addrctrl {};
	std::array<WXButton *, 4> buttons {};
	wxChoice *fmtctrl {};

	// 表示フォーマットの選択肢
	std::vector<std::pair<Memdump::Format, wxString>> fmts {};

	// コントロールパネルを格納する sizer
	wxBoxSizer *ctrlbox {};

	// コントロールパネル部分の長さ
	int fixed_height {};

	WXMonitorPanel *screen {};

	// モニタ ID
	int monid {};

	// メモリダンプウィンドウは複数枚あるので自分がそのうちの何番目か。
	int myidx {};

	// メモリダンプ
	MemdumpMonitor *memdump {};

	// イベントテーブル
	wxDECLARE_EVENT_TABLE();
};

// 編集ダイアログ
class MemEditDialog : public wxDialog
{
	using inherited = wxDialog;
 public:
	MemEditDialog(wxWindow *parent, uint32 addr, uint32 data, int len,
		const std::string& sizestr);
	~MemEditDialog() override;

	// テキストコントロールの値を返す
	uint64 GetData() const;

 private:
	void OnTextEnter(wxCommandEvent& event);

	// 値入力欄
	wxTextCtrl *datactrl {};

	// イベントテーブル
	wxDECLARE_EVENT_TABLE();
};
