//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// ログレベル設定ウィンドウ
//

#pragma once

#include "wxtextpanel.h"
#include "wxsubwindow.h"

class WXButton;

class WXLogSettingPanel : public WXTextPanel
{
	using inherited = WXTextPanel;

	static const int Padding = 3;

 public:
	explicit WXLogSettingPanel(wxWindow *parent);
	~WXLogSettingPanel() override;

	bool Layout() override;
	void FontChanged() override;
	void Draw() override;

 private:
	inline int Col2PX(int col) const;
	inline int Row2PY(int row) const;

	void OnButton(wxCommandEvent&);

	std::vector<Object *> objs {};

	// ボタン
	std::vector<WXButton *> buttons {};

	int maxnamelen {};
};

class WXLogSettingWindow : public WXSubWindow
{
	using inherited = WXSubWindow;

 public:
	explicit WXLogSettingWindow(wxWindow *);
	~WXLogSettingWindow() override;

 private:
	WXLogSettingPanel *panel {};
};
