//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// ROM 種別を表示するウィンドウ
//

#include "wxromwindow.h"
#include "mainapp.h"
#include "prom.h"
#include "romimg_x68k.h"

// コンストラクタ
WXROMWindow::WXROMWindow(wxWindow *parent)
	: inherited(parent, wxID_ANY, "ROM")
{
	int row;

	// ROM はアプリケーション起動後に変化しないので、初回実行時に情報収集。
	if (gMainApp.IsX68030()) {
		row = 3;
	} else {
		row = 1;
	}

	panel = new WXTextScreen(this, nnSize(52, row));
	auto& screen = panel->GetScreen();

	if (gMainApp.IsX68030()) {
		const auto iplrom1 = GetIPLROM1Device();
		const auto iplrom2 = GetIPLROM2Device();
		const auto cgrom   = GetCGROMDevice();
		const char *iplrom1_filename = iplrom1->GetFilename();
		const char *iplrom2_filename = iplrom2->GetFilename();
		const char *cgrom_filename = cgrom->GetFilename();

		screen.Print(0, 0, "IPLROM1($fe0000-$ffffff,128KB): %s",
			(iplrom1_filename ? "image file" : "Genuine IPLROM30.DAT"));
		screen.Print(0, 1, "IPLROM2($fc0000-$fdffff,128KB): %s",
			(iplrom2_filename ? "image file" : "nono's builtin"));
		screen.Print(0, 2, "CGROM  ($f00000-$fbffff,768KB): %s",
			(cgrom_filename ? "image file" : "nono's builtin"));
	} else {
		const auto prom = GetPROMDevice();
		const char *prom_filename = prom->GetFilename();

		screen.Print(0, 0, "PROM($41000000-): %s",
			(prom_filename ? "image file" : "nono's builtin"));
	}

	DoSize();
}

WXROMWindow::~WXROMWindow()
{
}
