//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// サブウィンドウ
//

#include "wxsubwindow.h"
#include "fontmanager.h"
#include "wxmainframe.h"
#include "wxtextscreen.h"

//
// サブウィンドウ (基本クラス)
//

// イベントテーブル
wxBEGIN_EVENT_TABLE(WXSubWindow, inherited)
	EVT_CLOSE(WXSubWindow::OnClose)
wxEND_EVENT_TABLE()

// コンストラクタ
WXSubWindow::WXSubWindow(wxWindow *parent, wxWindowID id, const wxString& name,
	int style)
	: inherited(parent, id, name, wxDefaultPosition, wxDefaultSize, style)
{
}

// デストラクタ
WXSubWindow::~WXSubWindow()
{
}

// クローズイベント
void
WXSubWindow::OnClose(wxCloseEvent& event)
{
	// ウィンドウリストから自身を削除
	auto mainframe = dynamic_cast<WXMainFrame*>(GetParent());
	mainframe->DeleteWindow(this);
}

// フォントサイズ変更
void
WXSubWindow::FontChanged()
{
	// WXTextPanel 派生の子コントロールに対し FontChanged() を呼ぶ
	for (auto child : GetChildren()) {
		auto textpanel = dynamic_cast<WXTextPanel*>(child);
		if (textpanel) {
			textpanel->FontChanged();
		}
	}

	DoSize();
}

// 中身に応じてこのウィンドウの大きさを変更
void
WXSubWindow::DoSize()
{
	wxSize csize;

	auto *topsizer = GetSizer();
	if (topsizer) {
		// Sizer があればそれがサイズを知っている
		csize = topsizer->GetMinSize();
	} else {
		// Sizer を使ってなければ子コントロールは1人のはず
		auto& children = GetChildren();
		assert(children.GetCount() == 1);
		auto child = children[0];
		csize = child->GetMinSize();
	}
	SetClientSize(csize);
}

// このサブウィンドウが縦リサイズ可能なテキストパネルの場合の Layout()。
// 本来は screen を持っている継承クラスが個別に行うことだが、定形処理なので
// ここでサブルーチンとして用意しておく。必要なら継承クラスが呼ぶこと。
bool
WXSubWindow::LayoutTextVResize(const WXTextScreen *screen, int fixed_height)
{
	if (inherited::Layout() == false) {
		return false;
	}

	wxSize tsize = GetSizer()->ComputeFittingClientSize(this);

	// 高さ計算。
	// 高さの最小は fixed と TextScreen 2行分にしておく。
	int h = fixed_height;
	h += screen->GetPaddingTop();
	h += screen->GetFontHeight() * 2;
	h += screen->GetPaddingBottom();

	// サイズを変える時は、大きくする時は Max を先に、小さくする時は Min を
	// 先に変えないと、サイズ制約の不整合の GTK ワーニングが出てしまう。
	// うーんこの API…。
	wxSize csize = GetClientSize();
	if (tsize.x > csize.x) {
		SetMaxClientSize(wxSize(tsize.x, wxDefaultCoord));
		SetMinClientSize(wxSize(tsize.x, h));
	} else {
		SetMinClientSize(wxSize(tsize.x, h));
		SetMaxClientSize(wxSize(tsize.x, wxDefaultCoord));
	}

	return true;
}
