//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// ログ
//

#include "logger.h"

// コンストラクタ
Logger::Logger()
{
}

// デストラクタ
Logger::~Logger()
{
}

// ログ書き込み
void
Logger::Write(const char *str)
{
	std::lock_guard<std::mutex> lk(mtx);
	// パイプへ出力 (EOL まで出力する)
	for (const char *s = str; ; s++) {
		if (pipe.IsFull()) {
			// 一杯なら古い 1 行を捨てる
			while (pipe.Dequeue() != '\0') {
				// nop
			}
		}
		pipe.Enqueue(*s);
		if (*s == '\0') {
			break;
		}
	}
	// 必要なら標準出力にも出力
	if (use_stdout) {
		printf("%s\n", str);
	}
}

// ログ読み出し
bool
Logger::Read(char *buf, int bufsize)
{
	uint8 ch;
	int i;

	std::lock_guard<std::mutex> lk(mtx);
	for (i = 0; i < bufsize - 1 && pipe.Dequeue(&ch); ) {
		buf[i++] = ch;
		if (ch == '\0') {
			break;
		}
	}
	// buf が足りない場合ここで打ち切り
	if (i == bufsize - 1) {
		// ただし EOL 含めて bufsize ぴったりなら取り出しておく
		if (pipe.Peek(0) == '\0') {
			pipe.Dequeue(&ch);
		}
		buf[i] = '\0';
	}
	return (i != 0);
}
