//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// パニック
//

#include "nono.h"
#include "mpu.h"

// パニック (PC を表示しない)
void
panic_func(const char *funcname, const char *fmt, ...)
{
	char fmtbuf[1024];
	va_list ap;

	va_start(ap, fmt);
	vsnprintf(fmtbuf, sizeof(fmtbuf), fmt, ap);
	va_end(ap);

	// panic の場合ここでプロセス終了するのでログではなく stderr に出力
	fprintf(stderr, "panic! %s at %s\n", fmtbuf, funcname);
	abort();
}

// VM 用パニック (PC を表示する)
void
vmpanic_func(const char *funcname, const char *fmt, ...)
{
	char fmtbuf[1024];
	va_list ap;

	va_start(ap, fmt);
	vsnprintf(fmtbuf, sizeof(fmtbuf), fmt, ap);
	va_end(ap);

	// panic の場合ここでプロセス終了するのでログではなく stderr に出力
	auto mpu = GetMPUDevice();
	fprintf(stderr, "panic! PC=$%08x %s at %s\n",
		mpu->GetPPC(), fmtbuf, funcname);
	abort();
}
