//
// nono
// Copyright (C) 2024 nono project
// Licensed under nono-license.txt
//

//
// VirtIO 定義
//

#include "virtio_def.h"
#include "mystring.h"

/*static*/ std::string
VirtIO::DeviceIDStr(uint32 id)
{
	static const char * const idnames[] = {
		"invalid",
		"Network Device",	// 1
		"Block Device",		// 2
		"Console Device",	// 3
		"Entropy Device",	// 4
		"Balloon Device",	// 5
		"6",				// 6
		"7",				// 7
		"SCSI Device",		// 8
	};
	assert(id < countof(idnames));
	return idnames[id];
}

/*static*/ std::string
VirtIO::StatusBits(uint32 status)
{
	static struct {
		uint32 bit;
		const char *name;
	} table[] = {
		{ STATUS_FAILED,		"FAILED" },
		{ STATUS_NEEDS_RESET,	"NEEDS_RESET" },
		{ STATUS_FEATURES_OK,	"F_OK" },
		{ STATUS_OK,			"OK" },
		{ STATUS_DRIVER,		"DRIVER" },
		{ STATUS_ACKNOWLEDGE,	"ACK" },
	};

	if (status == STATUS_RESET) {
		return "(RESET)";
	}

	std::string str;
	for (; status != 0; ) {
		// lowest は立ってる一番下のビットだけ取り出したもの
		decltype(status) lowest = status & (-status);

		str += ',';
		bool found = false;
		for (int i = 0; i < countof(table); i++) {
			if (table[i].bit == lowest) {
				str += table[i].name;
				found = true;
				break;
			}
		}
		if (found == false) {
			str += string_format("b%u", __builtin_ctz(lowest));
		}

		status &= ~lowest;
	}

	if (str.empty()) {
		return "<>";
	}
	str[0] = '<';
	str += '>';
	return str;
}

std::string
VirtQDesc::ToStr() const
{
	std::string str;

	str = string_format("addr=$%08x len=$%08x flags=$%04x(%c%c%c) next=$%04x",
		addr, len, flag,
		((flag & VIRTQ_DESC_F_INDIRECT) ? 'I' : '-'),
		((flag & VIRTQ_DESC_F_WRITE) ? 'W' : 'R'),
		((flag & VIRTQ_DESC_F_NEXT) ? 'N' : '-'),
		next);
	return str;
}
