//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// フォント管理
//

#pragma once

#include "wxnono.h"
#include <array>
#include <vector>

// フォント種別というかフォントサイズ。
// 配列のインデックスとして使うので有効な値を 0 から列挙する。
enum FontId {
	None = -1,
	_6x12 = 0,
	_8x16,
	_12x24,
	Max,
};
#define FONT_6x12	wxSize(6, 12)
#define FONT_8x16	wxSize(8, 16)
#define FONT_12x24	wxSize(12, 24)

// フォント管理
class FontManager
{
 public:
	FontManager();
	~FontManager();

	// フォントを変更(設定)
	void SetFont(FontId);

	// 現在のフォント ID を取得
	FontId GetFontId() const { return fontid; }

	// グリフを切り替える。
	// 0x5c は false: 円記号			true: バックスラッシュ
	// 0x7c は false: パイプ記号		true: パイプ記号(破線)
	// 0x7e は false: オーバーライン	true: チルダ
	void SetGlyph5C(bool value) { glyph_5c = value; }
	void SetGlyph7C(bool value) { glyph_7c = value; }
	void SetGlyph7E(bool value) { glyph_7e = value; }

	// ASCII のグリフを返す
	const uint8 *AsciiGlyph(uint8) const;

	// 漢字のグリフを返す
	const uint8 *KanjiGlyph(uint16) const;

	int GetFontWidth() const { return font_width; }
	int GetFontHeight() const { return font_height; }

 private:
	// フォント種別(指定値)
	// この値を元に各コントロールに指示を出す
	FontId fontid {};

	// フォントの諸元
	int font_width {};		// 幅 (ピクセル)
	int font_height {};		// 高さ (ピクセル)
	int font_stride {};		// 1行のバイト数
	int font_bytes {};		// 1フォントのバイト数

	// グリフデータ
	std::vector<uint8> ascii_glyph {};

	// 可変のグリフ
	bool glyph_5c {};
	bool glyph_7c {};
	bool glyph_7e {};

	// フォント種別一覧
	static const std::array<wxSize, FontId::Max> fontinfo;
};

extern FontManager *gFontManager;
