//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// 色管理
//

#pragma once

#include "color.h"

// カラーユニバーサルデザイン推奨配色セット (ver.4)
// https://jfly.uni-koeln.de/colorset/
//
// 基本はこの配色のみを用いること。
// ただし色を区別する(色の違いを認識できる)必要のない箇所ならここにない
// 色も使用可とする。

// アクセントカラー (文字など)
#define UD_RED				Color(255,  75,   0)	// 赤
#define UD_YELLOW			Color(255, 241,   0)	// 黄色
#define UD_GREEN			Color(  3, 175, 122)	// 緑
#define UD_BLUE				Color(  0,  90, 255)	// 青
#define UD_SKYBLUE			Color( 77, 196, 255)	// 空色
#define UD_PINK				Color(255, 128, 130)	// ピンク
#define UD_ORANGE			Color(246, 170,   0)	// オレンジ
#define UD_PURPLE			Color(153,   0, 153)	// 紫
#define UD_BROWN			Color(128,  64,   0)	// 茶色

// ベースカラー (背景など)
#define UD_LIGHT_PINK		Color(255, 202, 191)	// 明るいピンク
#define UD_CREAM			Color(255, 255, 128)	// クリーム
#define UD_YELLOW_GREEN		Color(216, 242,  85)	// 明るい黄緑
#define UD_LIGHT_SKYBLUE	Color(191, 228, 255)	// 明るい空色
#define UD_BEIGE			Color(255, 202, 128)	// ベージュ
#define UD_LIGHT_GREEN		Color(119, 217, 168)	// 明るい緑
#define UD_LIGHT_PURPLE		Color(201, 172, 230)	// 明るい紫

// 無彩色
#define UD_WHITE			Color(255, 255, 255)	// 白
#define UD_LIGHT_GREY		Color(200, 200, 203)	// 明るいグレー
#define UD_GREY				Color(132, 145, 158)	// グレー
#define UD_BLACK			Color(  0,   0,   0)	// 黒

// 以下独自色

// パネルの背景色。
// パネルの背景色は本来 wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOW) で
// 取得できる色だと思うが、これが環境依存となると前景色との兼ね合いも再現
// できなくなるということなのでこれには依存せず、背景色は自分で確定させる。
// UD_LIGHT_GREY は背景用ではないので背景色にするには暗い。
// wxGTK(2) の wxLIGHT_GREY は (211, 211, 211) で、これも結構暗め。
// wxGTK3 はほぼ白(250) で、これは明るすぎて好みではない。
#define BGPANEL				Color(224, 224, 227)
