//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// MPU 関係のモニターウィンドウ
//

#include "wxmpumonitor.h"

//
// CMMU キャッシュウィンドウ
//

// コンストラクタ
WXCacheWindow::WXCacheWindow(wxWindow *parent, const wxString& name,
	Monitor *monitor_)
	: inherited(parent, name, monitor_)
{
	// モニタパネルに送られるマウスイベントをこちらで処理する
	monpanel->Connect(wxEVT_LEFT_DOWN,
		wxMouseEventHandler(WXCacheWindow::OnLeftDown), NULL, this);
}

// デストラクタ
WXCacheWindow::~WXCacheWindow()
{
}

// マウス左クリックイベント
void
WXCacheWindow::OnLeftDown(wxMouseEvent& event)
{
	const wxPoint& pos = event.GetPosition();

	// テキストの桁数、行数にする
	wxPoint tpos = monpanel->GetTextPosition(pos);
	int x = tpos.x;
	int y = tpos.y;

	// クリックされた場所のセット番号に更新
	x -= 3;
	y -= 1;
	if (x >= 0 && y >= 0 && y < 16) {
		// セットとセットの間の空白には反応しないようにしたい
		if (x % 5 < 4) {
			// このモニタは userdata を現在のセット番号として使っている
			int setidx = y * 16 + (x / 5);
			monpanel->SetUserData(setidx);
		}
	}

	// 画面更新
	monpanel->DoRefresh();

	event.Skip();
}
