//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// サウンドの Wav ドライバ
//

#pragma once

#include "sounddriver.h"

class SoundDriverWav : public SoundDriver
{
	using inherited = SoundDriver;
 public:
	explicit SoundDriverWav(HostDevice *hostdev_);
	~SoundDriverWav() override;

	bool InitDriver(bool startup = true) override;

	void Write(const int16 *) override;

	void MonitorUpdateMD(TextScreen&, int y) override;

 private:
	bool OpenWav();
	void CloseWav();

	void fwrite4LE(FILE *, uint32 val);

	FILE *fp {};

	// 出力 WAV ファイルのファイル名部分
	std::string filename {};

	// 書き込んだバイト数
	uint32 databytes {};

	// バイトスワップ用のバッファ
	std::vector<int16> le16buf {};

	static const uint8 wav_header[0x2c];
};
