//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// LCD (HD44780)
//

#pragma once

#include "device.h"

class UIMessage;

class LCDDevice : public Device
{
	using inherited = Device;
 public:
	LCDDevice();
	~LCDDevice() override;

	bool Init() override;
	void ResetHard(bool poweron) override;
	void PowerOff() override;

	// リセット信号はない

	// R/~W を val にセットする。true=R、false=W
	void SetRW(bool val);

	// RS を val にセットする。
	// false=コマンド(W)/ステータス(R)レジスタ
	// true=データレジスタ
	void SetRS(bool val);

	// E を val にセットする。
	void SetE(bool val);

	// E, RS, R/W 線の状態を取得する。
	// PIO1 のポートC 読み込み用。
	uint8 Get() const;

	// 読み込む。
	uint8 Read();

	// 書き込む。
	void Write(uint8 data);

	// PIO1 のポートA ピーク用
	uint8 Peek() const;

	// バッファを取得 (内容表示用)
	const uint8 *GetDDRAM() const { return ddram; }

	// フォントを取得
	const uint8 *GetFont(uint ch) const;

 private:
	DECLARE_MONITOR_CALLBACK(MonitorUpdate);

	// 現在のアドレスでデータレジスタにラッチ
	void LatchData();
	// アドレスカウンタ設定
	void SetAddr(uint addr, bool is_cgram);
	// アドレスカウンタを次へ進める
	void NextAddr();

	// 信号線
	bool en {};			// Enable
	bool rw {};			// true=R false=W
	bool rs {};			// レジスタセレクト true=Data false=Command/Status

	bool addr_inc {};	// アドレス・インクリメント true=inc false=dec
	bool disp_char {};	// 文字表示をするか

	// データレジスタ
	uint8 data_reg {};

	// アドレスカウンタ
	uint addr_counter {};
	bool addr_is_cgram {};	// addr が CGRAM アドレスなら true

	uint8 ddram[0x80] {};
	uint8 cgram[0x40] {};

	Monitor *monitor {};

	UIMessage *uimessage {};

	static const uint8 CGROM[12 * 16 * 8];
};

static inline LCDDevice *GetLCDDevice() {
	return Object::GetObject<LCDDevice>(OBJ_LCD);
}
