//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// メインバス (NEWS)
//

#pragma once

#include "mainbus.h"

class NewsMainbus : public Mainbus24Device
{
	using inherited = Mainbus24Device;
 public:
	NewsMainbus();
	~NewsMainbus() override;

	bool InitMainbus() override;

 private:
	// ブートページを切り替える。
	void SwitchBootPage(bool isrom) override;

	std::unique_ptr<IODevice> pBusErr {};
	std::unique_ptr<IODevice> pInterrupt {};
	std::unique_ptr<IODevice> pMainRAM {};
	std::unique_ptr<IODevice> pNewsCtlr {};
	std::unique_ptr<IODevice> pNewsIO {};
	std::unique_ptr<IODevice> pNopIO {};
	std::unique_ptr<IODevice> pPROM {};
};
