//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// 外字データ
//

#include "bitops.h"
#include "privatechar.h"

#define B(x)	(0b##x)
#define W(x)	(B(x) >> 8), (B(x) & 0xff)

constexpr private_char private_chars[] {
	{ 0x01, // 早送りの三角
	  {
		B(000000'00),		// 0
		B(100000'00),		// 1
		B(110000'00),		// 2
		B(111000'00),		// 3
		B(111100'00),		// 4
		B(111110'00),		// 5
		B(111111'00),		// 6
		B(111110'00),		// 7
		B(111100'00),		// 8
		B(111000'00),		// 9
		B(110000'00),		// a
		B(100000'00),		// b
	  }, {
		B(00000000),		// 0
		B(10000000),		// 1
		B(11000000),		// 2
		B(11100000),		// 3
		B(11110000),		// 4
		B(11111000),		// 5
		B(11111100),		// 6
		B(11111110),		// 7
		B(11111111),		// 8
		B(11111110),		// 9
		B(11111100),		// a
		B(11111000),		// b
		B(11110000),		// c
		B(11100000),		// d
		B(11000000),		// e
		B(10000000),		// f
	  }, {
		W(000000000000'0000),	// 0
		W(100000000000'0000),	// 1
		W(110000000000'0000),	// 2
		W(111000000000'0000),	// 3
		W(111100000000'0000),	// 4
		W(111110000000'0000),	// 5
		W(111111000000'0000),	// 6
		W(111111100000'0000),	// 7
		W(111111110000'0000),	// 8
		W(111111111000'0000),	// 9
		W(111111111100'0000),	// 10
		W(111111111110'0000),	// 11
		W(111111111111'0000),	// 12
		W(111111111110'0000),	// 13
		W(111111111100'0000),	// 14
		W(111111111000'0000),	// 15
		W(111111110000'0000),	// 16
		W(111111100000'0000),	// 17
		W(111111000000'0000),	// 18
		W(111110000000'0000),	// 19
		W(111100000000'0000),	// 20
		W(111000000000'0000),	// 21
		W(110000000000'0000),	// 22
		W(100000000000'0000),	// 23
	  }
	},

	{ 0x02,	// ライト無視(1文字目)
	  {
		B(000000'00),		// 0
		B(000000'00),		// 1
		B(000000'00),		// 2
		B(111111'00),		// 3
		B(101010'00),		// 4
		B(101010'00),		// 5
		B(100000'00),		// 6
		B(110101'00),		// 7
		B(110101'00),		// 8
		B(111111'00),		// 9
		B(000000'00),		// a
		B(000000'00),		// b
	  }, {
		B(00000000),		// 0
		B(00000000),		// 1
		B(00000000),		// 2
		B(00000000),		// 3
		B(00000000),		// 4
		B(01111111),		// 5
		B(01011101),		// 6
		B(01010101),		// 7
		B(01010101),		// 8
		B(01000001),		// 9
		B(01101011),		// a
		B(01101011),		// b
		B(01111111),		// c
		B(00000000),		// d
		B(00000000),		// e
		B(00000000),		// f
	  }, {
		W(000000000000'0000),	// 0
		W(000000000000'0000),	// 1
		W(000000000000'0000),	// 2
		W(000000000000'0000),	// 3
		W(000000000000'0000),	// 4
		W(000000000000'0000),	// 5
		W(001111111111'0000),	// 6
		W(011111111111'0000),	// 7
		W(011101111101'0000),	// 8
		W(011101111101'0000),	// 9
		W(011101111101'0000),	// 10
		W(011101101101'0000),	// 11
		W(011101101101'0000),	// 12
		W(011101010101'0000),	// 13
		W(011101010101'0000),	// 14
		W(011110111011'0000),	// 15
		W(011110111011'0000),	// 16
		W(011110111011'0000),	// 17
		W(011111111111'0000),	// 18
		W(001111111111'0000),	// 19
		W(000000000000'0000),	// 20
		W(000000000000'0000),	// 21
		W(000000000000'0000),	// 22
		W(000000000000'0000),	// 23
	  }
	},

	{ 0x03, // ライト無視(2文字目)
	  {
		B(000000'00),		// 0
		B(000000'00),		// 1
		B(000000'00),		// 2
		B(111110'00),		// 3
		B(100010'00),		// 4
		B(110110'00),		// 5
		B(110110'00),		// 6
		B(110110'00),		// 7
		B(100010'00),		// 8
		B(111110'00),		// 9
		B(000000'00),		// a
		B(000000'00),		// b
	  }, {
		B(00000000),		// 0
		B(00000000),		// 1
		B(00000000),		// 2
		B(00000000),		// 3
		B(00000000),		// 4
		B(11111100),		// 5
		B(10001100),		// 6
		B(11011100),		// 7
		B(11011100),		// 8
		B(11011100),		// 9
		B(11011100),		// a
		B(10001100),		// b
		B(11111100),		// c
		B(00000000),		// d
		B(00000000),		// e
		B(00000000),		// f
	  }, {
		W(000000000000'0000),	// 0
		W(000000000000'0000),	// 1
		W(000000000000'0000),	// 2
		W(000000000000'0000),	// 3
		W(000000000000'0000),	// 4
		W(000000000000'0000),	// 5
		W(111111111000'0000),	// 6
		W(111111111100'0000),	// 7
		W(110000011100'0000),	// 8
		W(111101111100'0000),	// 9
		W(111101111100'0000),	// 10
		W(111101111100'0000),	// 11
		W(111101111100'0000),	// 12
		W(111101111100'0000),	// 13
		W(111101111100'0000),	// 14
		W(111101111100'0000),	// 15
		W(111101111100'0000),	// 16
		W(110000011100'0000),	// 17
		W(111111111100'0000),	// 18
		W(111111111000'0000),	// 19
		W(000000000000'0000),	// 20
		W(000000000000'0000),	// 21
		W(000000000000'0000),	// 22
		W(000000000000'0000),	// 23
	  }
	},

	{ 0x04,	// 4文字幅の BREAK (1文字目)
	  {
		B(000000'00),		// 0
		B(111001'00),		// 1
		B(100101'00),		// 2
		B(100101'00),		// 3
		B(100101'00),		// 4
		B(111001'00),		// 5
		B(100101'00),		// 6
		B(100101'00),		// 7
		B(100101'00),		// 8
		B(111001'00),		// 9
		B(000000'00),		// a
		B(000000'00),		// b
	  }, {
		B(00000000),		// 0
		B(00000000),		// 1
		B(01111100),		// 2
		B(00100010),		// 3
		B(00100010),		// 4
		B(00100010),		// 5
		B(00100010),		// 6
		B(00111100),		// 7
		B(00100010),		// 8
		B(00100010),		// 9
		B(00100010),		// a
		B(00100010),		// b
		B(00100010),		// c
		B(01111100),		// d
		B(00000000),		// e
		B(00000000),		// f
	  }, {
		W(000000000000'0000),	// 0
		W(000000000000'0000),	// 1
		W(000000000000'0000),	// 2
		W(111111100011'0000),	// 3
		W(011000010001'0000),	// 4
		W(011000011001'0000),	// 5
		W(011000011001'0000),	// 6
		W(011000011001'0000),	// 7
		W(011000011001'0000),	// 8
		W(011000110001'0000),	// 9
		W(011111100001'0000),	// 10
		W(011000010001'0000),	// 11
		W(011000011001'0000),	// 12
		W(011000001101'0000),	// 13
		W(011000001101'0000),	// 14
		W(011000001101'0000),	// 15
		W(011000001101'0000),	// 16
		W(011000001101'0000),	// 17
		W(011000001101'0000),	// 18
		W(011000011001'0000),	// 19
		W(011111100011'0000),	// 20
		W(000000000000'0000),	// 21
		W(000000000000'0000),	// 22
		W(000000000000'0000),	// 23
	  }
	},

	{ 0x05,	// 4文字幅の BREAK (2文字目)
	  {
		B(000000'00),		// 0
		B(110011'00),		// 1
		B(001010'00),		// 2
		B(001010'00),		// 3
		B(001010'00),		// 4
		B(110011'00),		// 5
		B(010010'00),		// 6
		B(001010'00),		// 7
		B(001010'00),		// 8
		B(001011'00),		// 9
		B(000000'00),		// a
		B(000000'00),		// b
	  }, {
		B(00000000),		// 0
		B(00000000),		// 1
		B(11110011),		// 2
		B(10001010),		// 3
		B(10001010),		// 4
		B(10001010),		// 5
		B(10001010),		// 6
		B(11110011),		// 7
		B(10010010),		// 8
		B(10010010),		// 9
		B(10001010),		// a
		B(10001010),		// b
		B(10001010),		// c
		B(10001011),		// d
		B(00000000),		// e
		B(00000000),		// f
	  }, {
		W(000000000000'0000),	// 0
		W(000000000000'0000),	// 1
		W(000000000000'0000),	// 2
		W(111110011111'0000),	// 3
		W(100011001100'0000),	// 4
		W(100001101100'0000),	// 5
		W(100001101100'0000),	// 6
		W(100001101100'0000),	// 7
		W(100001101100'0000),	// 8
		W(100011001100'0000),	// 9
		W(111100001111'0000),	// 10
		W(100110001100'0000),	// 11
		W(100011001100'0000),	// 12
		W(100011001100'0000),	// 13
		W(100011001100'0000),	// 14
		W(100001101100'0000),	// 15
		W(100001101100'0000),	// 16
		W(100001101100'0000),	// 17
		W(100001101100'0000),	// 18
		W(100001101100'0000),	// 19
		W(110011111111'0000),	// 20
		W(000000000000'0000),	// 21
		W(000000000000'0000),	// 22
		W(000000000000'0000),	// 23
	  }
	},

	{ 0x06,	// 4文字幅の BREAK (3文字目)
	  {
		B(000000'00),		// 0
		B(110011'00),		// 1
		B(000100'00),		// 2
		B(000100'00),		// 3
		B(000100'00),		// 4
		B(100111'00),		// 5
		B(000100'00),		// 6
		B(000100'00),		// 7
		B(000100'00),		// 8
		B(110100'00),		// 9
		B(000000'00),		// a
		B(000000'00),		// b
	  }, {
		B(00000000),		// 0
		B(00000000),		// 1
		B(11100010),		// 2
		B(00000010),		// 3
		B(00000101),		// 4
		B(00000101),		// 5
		B(00000101),		// 6
		B(11001000),		// 7
		B(00001000),		// 8
		B(00001000),		// 9
		B(00001111),		// a
		B(00001000),		// b
		B(00001000),		// c
		B(11101000),		// d
		B(00000000),		// e
		B(00000000),		// f
	  }, {
		W(000000000000'0000),	// 0
		W(000000000000'0000),	// 1
		W(000000000000'0000),	// 2
		W(111000011000'0000),	// 3
		W(001000011000'0000),	// 4
		W(001000011000'0000),	// 5
		W(000100011000'0000),	// 6
		W(000000101100'0000),	// 7
		W(010000101100'0000),	// 8
		W(010000101100'0000),	// 9
		W(110000101100'0000),	// 10
		W(010001000110'0000),	// 11
		W(010001000110'0000),	// 12
		W(000001000110'0000),	// 13
		W(000001111110'0000),	// 14
		W(000001000110'0000),	// 15
		W(000010000011'0000),	// 16
		W(000010000011'0000),	// 17
		W(001010000011'0000),	// 18
		W(001010000011'0000),	// 19
		W(111011100111'0000),	// 20
		W(000000000000'0000),	// 21
		W(000000000000'0000),	// 22
		W(000000000000'0000),	// 23
	  }
	},

	{ 0x07,	// 4文字幅の BREAK (4文字目)
	  {
		B(000000'00),		// 0
		B(001001'00),		// 1
		B(101010'00),		// 2
		B(101010'00),		// 3
		B(101100'00),		// 4
		B(101100'00),		// 5
		B(101010'00),		// 6
		B(101010'00),		// 7
		B(101001'00),		// 8
		B(101001'00),		// 9
		B(000000'00),		// a
		B(000000'00),		// b
	  }, {
		B(00000000),		// 0
		B(00000000),		// 1
		B(00100010),		// 2
		B(00100010),		// 3
		B(00100100),		// 4
		B(00100100),		// 5
		B(00101000),		// 6
		B(10110000),		// 7
		B(10101000),		// 8
		B(10101000),		// 9
		B(10100100),		// a
		B(10100100),		// b
		B(10100010),		// c
		B(10100010),		// d
		B(00000000),		// e
		B(00000000),		// f
	  }, {
		W(000000000000'0000),	// 0
		W(000000000000'0000),	// 1
		W(000000000000'0000),	// 2
		W(011110000111'0000),	// 3
		W(001100000010'0000),	// 4
		W(001100000100'0000),	// 5
		W(001100000100'0000),	// 6
		W(001100001000'0000),	// 7
		W(001100010000'0000),	// 8
		W(001100010000'0000),	// 9
		W(001100100000'0000),	// 10
		W(001101110000'0000),	// 11
		W(001110110000'0000),	// 12
		W(001100011000'0000),	// 13
		W(001100011000'0000),	// 14
		W(001100011000'0000),	// 15
		W(001100001100'0000),	// 16
		W(001100001100'0000),	// 17
		W(001100000110'0000),	// 18
		W(001100000110'0000),	// 19
		W(111110001111'0000),	// 20
		W(000000000000'0000),	// 21
		W(000000000000'0000),	// 22
		W(000000000000'0000),	// 23
	  }
	},

	{ 0x08,	// (アキ)
	},

	// 0x09 は '\t'、
	// 0x0a は '\n' なので割り当てない

	{ 0x0b,	// 4文字幅の ENTER (1文字目)
	  {
		B(000000'00),		// 0
		B(111101'00),		// 1
		B(100001'00),		// 2
		B(100001'00),		// 3
		B(100001'00),		// 4
		B(111001'00),		// 5
		B(100001'00),		// 6
		B(100001'00),		// 7
		B(100001'00),		// 8
		B(111101'00),		// 9
		B(000000'00),		// a
		B(000000'00),		// b
	  }, {
		B(00000000),		// 0
		B(00000000),		// 1
		B(01111101),		// 2
		B(01000001),		// 3
		B(01000001),		// 4
		B(01000001),		// 5
		B(01000001),		// 6
		B(01111001),		// 7
		B(01000001),		// 8
		B(01000001),		// 9
		B(01000001),		// a
		B(01000001),		// b
		B(01000001),		// c
		B(01111101),		// d
		B(00000000),		// e
		B(00000000),		// f
	  }, {
		W(000000000000'0000),	// 0
		W(000000000000'0000),	// 1
		W(000000000000'0000),	// 2
		W(111111111110'0000),	// 3
		W(011000010110'0000),	// 4
		W(011000010111'0000),	// 5
		W(011000000101'0000),	// 6
		W(011000000101'0000),	// 7
		W(011000010101'0000),	// 8
		W(011000010100'0000),	// 9
		W(011111110100'0000),	// 10
		W(011000010100'0000),	// 11
		W(011000010100'0000),	// 12
		W(011000000100'0000),	// 13
		W(011000000100'0000),	// 14
		W(011000000100'0000),	// 15
		W(011000000100'0000),	// 16
		W(011000000100'0000),	// 17
		W(011000010100'0000),	// 18
		W(011000010100'0000),	// 19
		W(111111110110'0000),	// 20
		W(000000000000'0000),	// 21
		W(000000000000'0000),	// 22
		W(000000000000'0000),	// 23
	  }
	},

	{ 0x0c,	// 4文字幅の ENTER (2文字目)
	  {
		B(000000'00),		// 0
		B(001011'00),		// 1
		B(101001'00),		// 2
		B(101001'00),		// 3
		B(101001'00),		// 4
		B(011001'00),		// 5
		B(011001'00),		// 6
		B(011001'00),		// 7
		B(001001'00),		// 8
		B(001001'00),		// 9
		B(000000'00),		// a
		B(000000'00),		// b
	  }, {
		B(00000000),		// 0
		B(00000000),		// 1
		B(00010111),		// 2
		B(00010001),		// 3
		B(10010001),		// 4
		B(10010001),		// 5
		B(10010001),		// 6
		B(01010001),		// 7
		B(01010001),		// 8
		B(00110001),		// 9
		B(00110001),		// a
		B(00110001),		// b
		B(00010001),		// c
		B(00010001),		// d
		B(00000000),		// e
		B(00000000),		// f
	  }, {
		W(000000000000'0000),	// 0
		W(000000000000'0000),	// 1
		W(000000000000'0000),	// 2
		W(000011101111'0000),	// 3
		W(000001010001'0000),	// 4
		W(000001010001'0000),	// 5
		W(000001000001'0000),	// 6
		W(100001000001'0000),	// 7
		W(100001000001'0000),	// 8
		W(110001000001'0000),	// 9
		W(110001000001'0000),	// 10
		W(011001000001'0000),	// 11
		W(011001000001'0000),	// 12
		W(001101000001'0000),	// 13
		W(001101000001'0000),	// 14
		W(000111000001'0000),	// 15
		W(000111000001'0000),	// 16
		W(000011000001'0000),	// 17
		W(000011000001'0000),	// 18
		W(000001000001'0000),	// 19
		W(000001000111'0000),	// 20
		W(000000000000'0000),	// 21
		W(000000000000'0000),	// 22
		W(000000000000'0000),	// 23
	  }
	},

	// 0x0d は '\r' なので割り当てない

	{ 0x0e,	// 4文字幅の ENTER (3文字目)
	  {
		B(000000'00),		// 0
		B(101111'00),		// 1
		B(001000'00),		// 2
		B(001000'00),		// 3
		B(001000'00),		// 4
		B(001110'00),		// 5
		B(001000'00),		// 6
		B(001000'00),		// 7
		B(001000'00),		// 8
		B(001111'00),		// 9
		B(000000'00),		// a
		B(000000'00),		// b
	  }, {
		B(00000000),		// 0
		B(00000000),		// 1
		B(11011111),		// 2
		B(00010000),		// 3
		B(00010000),		// 4
		B(00010000),		// 5
		B(00010000),		// 6
		B(00011110),		// 7
		B(00010000),		// 8
		B(00010000),		// 9
		B(00010000),		// a
		B(00010000),		// b
		B(00010000),		// c
		B(00011111),		// d
		B(00000000),		// e
		B(00000000),		// f
	  }, {
		W(000000000000'0000),	// 0
		W(000000000000'0000),	// 1
		W(000000000000'0000),	// 2
		W(111101111111'0000),	// 3
		W(100010110000'0000),	// 4
		W(100010110000'0000),	// 5
		W(100010110000'0000),	// 6
		W(100000110000'0000),	// 7
		W(100000110001'0000),	// 8
		W(100000110001'0000),	// 9
		W(100000111111'0000),	// 10
		W(100000110001'0000),	// 11
		W(100000110001'0000),	// 12
		W(100000110001'0000),	// 13
		W(100000110000'0000),	// 14
		W(100000110000'0000),	// 15
		W(100000110000'0000),	// 16
		W(100000110000'0000),	// 17
		W(100000110000'0000),	// 18
		W(100000110000'0000),	// 19
		W(110001111111'0000),	// 20
		W(000000000000'0000),	// 21
		W(000000000000'0000),	// 22
		W(000000000000'0000),	// 23
	  }
	},

	{ 0x0f,	// 4文字幅の ENTER (4文字目)
	  {
		B(000000'00),		// 0
		B(111000'00),		// 1
		B(100100'00),		// 2
		B(100100'00),		// 3
		B(100100'00),		// 4
		B(111000'00),		// 5
		B(101000'00),		// 6
		B(100100'00),		// 7
		B(100100'00),		// 8
		B(100100'00),		// 9
		B(000000'00),		// a
		B(000000'00),		// b
	  }, {
		B(00000000),		// 0
		B(00000000),		// 1
		B(01111000),		// 2
		B(01000100),		// 3
		B(01000100),		// 4
		B(01000100),		// 5
		B(01000100),		// 6
		B(01111000),		// 7
		B(01001000),		// 8
		B(01001000),		// 9
		B(01000100),		// a
		B(01000100),		// b
		B(01000100),		// c
		B(01000100),		// d
		B(00000000),		// e
		B(00000000),		// f
	  }, {
		W(000000000000'0000),	// 0
		W(000000000000'0000),	// 1
		W(000000000000'0000),	// 2
		W(101111111000'0000),	// 3
		W(101100001100'0000),	// 4
		W(101100000110'0000),	// 5
		W(101100000110'0000),	// 6
		W(001100000110'0000),	// 7
		W(001100000110'0000),	// 8
		W(001100001100'0000),	// 9
		W(001111110000'0000),	// 10
		W(001100011000'0000),	// 11
		W(001100001100'0000),	// 12
		W(001100001100'0000),	// 13
		W(001100001100'0000),	// 14
		W(001100000110'0000),	// 15
		W(001100000110'0000),	// 16
		W(001100000110'0000),	// 17
		W(101100000110'0000),	// 18
		W(101100000110'0000),	// 19
		W(111110001111'0000),	// 20
		W(000000000000'0000),	// 21
		W(000000000000'0000),	// 22
		W(000000000000'0000),	// 23
	  }
	},

	{ 0 },	// 番兵
};
