//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// 逆アセンブラ (共通部分)
//

#pragma once

#include "debugger_private.h"

// 逆アセンブラ(1行分)の基本クラス。
class DisasmLine
{
 public:
	virtual ~DisasmLine();

	// mem の位置を1命令逆アセンブルする。
	// 成功すれば true、失敗すれば false を返す?
	// 成功すれば text に出力文字列、ir に命令バイナリがセットされている。
	virtual bool Exec(DebuggerMemoryStream *memp) = 0;

	// 出力文字列(ダンプ)
	std::string dump {};

	// 出力文字列(命令)
	std::string text {};

	// 別名 (m88k で使う)
	std::string alttext {};

	// この命令のバイナリ列
	// (メモリイメージ順)
	std::vector<uint8> bin {};

	// メモリアクセス
	DebuggerMemoryStream *mem {};

 protected:
	// 継承先の Exec() の先頭で呼び出すこと。
	void ExecInit(DebuggerMemoryStream *mem_) {
		mem = mem_;
		dump.clear();
		text.clear();
		alttext.clear();
		bin.clear();
	}
};
