//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// 色構造体
//

#pragma once

#include "header.h"

//
// 自前の色構造体。
// メモリ上 { R, G, B, X } になる順。
// uint32 で読むと LE では 0xXXBBGGRR、BE では 0xRRGGBBXX と読める。
//
union Color
{
	uint32 u32 {};
	struct {
		uint8 r;
		uint8 g;
		uint8 b;
		uint8 x;
	};

	Color() { }
	Color(uint32 u32_) {
		u32 = u32_;
	}
	Color(int r_, int g_, int b_) {
		r = r_;
		g = g_;
		b = b_;
		x = 0;
	}
};

// カラーユニバーサルデザイン推奨配色セット (ver.4)
// https://jfly.uni-koeln.de/colorset/
//
// 基本はこの配色のみを用いること。
// ただし色を区別する(色の違いを認識できる)必要のない箇所ならここにない
// 色も使用可とする。

// アクセントカラー (文字など)
#define UD_RED				Color(255,  75,   0)	// FF4B00: 赤
#define UD_YELLOW			Color(255, 241,   0)	// FFF100: 黄色
#define UD_GREEN			Color(  3, 175, 122)	// 03AF7A: 緑
#define UD_BLUE				Color(  0,  90, 255)	// 005AFF: 青
#define UD_SKYBLUE			Color( 77, 196, 255)	// 4DC4FF: 空色
#define UD_PINK				Color(255, 128, 130)	// FF8082: ピンク
#define UD_ORANGE			Color(246, 170,   0)	// F6AA00: オレンジ
#define UD_PURPLE			Color(153,   0, 153)	// 990099: 紫
#define UD_BROWN			Color(128,  64,   0)	// 804000: 茶色

// ベースカラー (背景など)
#define UD_LIGHT_PINK		Color(255, 202, 191)	// FFCABF: 明るいピンク
#define UD_CREAM			Color(255, 255, 128)	// FFFF80: クリーム
#define UD_YELLOW_GREEN		Color(216, 242,  85)	// D8F255: 明るい黄緑
#define UD_LIGHT_SKYBLUE	Color(191, 228, 255)	// BFE4FF: 明るい空色
#define UD_BEIGE			Color(255, 202, 128)	// FFCA80: ベージュ
#define UD_LIGHT_GREEN		Color(119, 217, 168)	// 77D9A8: 明るい緑
#define UD_LIGHT_PURPLE		Color(201, 172, 230)	// C9ACE6: 明るい紫

// 無彩色
#define UD_WHITE			Color(255, 255, 255)	// FFFFFF: 白
#define UD_LIGHT_GREY		Color(200, 200, 203)	// C8C8CB: 明るいグレー
#define UD_GREY				Color(132, 145, 158)	// 84919E: グレー
#define UD_BLACK			Color(  0,   0,   0)	// 000000: 黒

// 以下独自色

// パネルの背景色。
// パネルの背景色は本来 wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOW) で
// 取得できる色だと思うが、これが環境依存となると前景色との兼ね合いも再現
// できなくなるということなのでこれには依存せず、背景色は自分で確定させる。
// UD_LIGHT_GREY は背景用ではないので背景色にするには暗い。
// wxGTK(2) の wxLIGHT_GREY は (211, 211, 211) で、これも結構暗め。
// wxGTK3 はほぼ白(250) で、これは明るすぎて好みではない。
#define BGPANEL				Color(224, 224, 227)	// E0E0E3
