//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// バスエラー(デバイス)
//

#pragma once

#include "device.h"

class BusErrDevice : public IODevice
{
	using inherited = IODevice;
 public:
	BusErrDevice();
	~BusErrDevice() override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr addr, uint32 data) override;
	busdata Peek1(uint32 addr) override;
};

static inline BusErrDevice *GetBusErrDevice() {
	return Object::GetObject<BusErrDevice>(OBJ_BUSERR);
}
