//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// デバイスの基本クラスなど
//

#include "device.h"
#include "mpu.h"
#include "scheduler.h"

//
// Device
//

// コンストラクタ
Device::Device(uint objid_)
	: inherited(objid_)
{
}

// デストラクタ
Device::~Device()
{
}

bool
Device::Create()
{
	return true;
}

bool
Device::Create2()
{
	return true;
}

void
Device::EarlyInit()
{
	mpu = GetMPUDevice();
	scheduler = GetScheduler();
}

bool
Device::Init()
{
	return true;
}

void
Device::ResetHard(bool poweron)
{
}

void
Device::PowerOff()
{
}

// ログ表示。
// VM デバイスでは、仮想時間、PC、オブジェクト名を表示する。
void
Device::putlogn(const char *fmt, ...) const
{
	char buf[1024];
	va_list ap;
	uint64 vt;
	int len;

	vt = scheduler->GetVirtTime();
	len = snprintf(buf, sizeof(buf), "%4u.%03u'%03u'%03u %08x %s ",
		(uint)(vt / 1000 / 1000 / 1000),
		(uint)((vt / 1000 / 1000) % 1000),
		(uint)((vt / 1000) % 1000),
		(uint)(vt % 1000),
		mpu->GetPPC(),
		GetName().c_str());

	va_start(ap, fmt);
	vsnprintf(buf + len, sizeof(buf) - len, fmt, ap);
	va_end(ap);

	WriteLog(buf);
}


//
// IODevice
//

// コンストラクタ
IODevice::IODevice(uint objid_)
	: inherited(objid_)
{
}

// デストラクタ
IODevice::~IODevice()
{
}

busdata
IODevice::Read(busaddr addr)
{
	return 0;
}

busdata
IODevice::Write(busaddr addr, uint32 data)
{
	return 0;
}

busdata
IODevice::ReadBurst16(busaddr addr, uint32 *dst)
{
	return BusData::BusErr;
}

busdata
IODevice::WriteBurst16(busaddr addr, const uint32 *src)
{
	return BusData::BusErr;
}

busdata
IODevice::Read1(uint32 addr)
{
	return 0xff;
}

busdata
IODevice::Write1(uint32 addr, uint32 data)
{
	return 0;
}

busdata
IODevice::Peek1(uint32 addr)
{
	return 0xff;
}

bool
IODevice::Poke1(uint32 addr, uint32 data)
{
	return false;
}
