//
// nono
// Copyright (C) 2024 nono project
// Licensed under nono-license.txt
//

//
// Goldfish (Qemu) RTC+Timer (の Timer のほう)
//

#include "device.h"

class GFRTCDevice;
class InterruptDevice;
class Syncer;

class GFTimerDevice : public IODevice
{
	using inherited = IODevice;

 public:
	GFTimerDevice();
	~GFTimerDevice() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

 protected:
	// BusIO インタフェース
	static const uint32 NPORT = 0x1000 >> 2;
	busdata ReadPort(uint32 offset);
	busdata WritePort(uint32 offset, uint32 data);
	busdata PeekPort(uint32 offset);

 private:
	DECLARE_MONITOR_SCREEN(MonitorScreen);

	void CallbackVT(Event *);
	void CallbackRT(Event *);
	void ChangeInterrupt();

	// アラーム開始。
	void StartAlarm();

	// 現在時刻取得
	uint64 Now() const;

	// TIMER レジスタ読み出し値。(アラームの基準点としても使う)
	uint64 elapsed {};

	// アラーム予定時刻 (0 ならアラームなし)
	uint64 alarm {};

	// 先に書き込まれた上位側を一旦保持しておくところ。
	uint64 alarm_high {};

	bool sync_rt {};

	// 実時間同期用
	uint64 mtime_epoch {};	// 調整実時間軸の起点(仮想時刻)
	uint64 mtime {};		// 自身の調整実時間。(mtime_epoch からの経過時間)

	bool intr_enable {};	// 割り込み許可
	bool intr_assert {};	// 割り込み発生

	Event *event {};

	Monitor *monitor {};

	GFRTCDevice *gfrtc {};
	InterruptDevice *interrupt {};
	Syncer *syncer {};
};

static inline GFTimerDevice *GetGFTimerDevice() {
	return Object::GetObject<GFTimerDevice>(OBJ_GFTIMER);
}
