//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// PROM (LUNA-I, LUNA-88K 共通)
//

#pragma once

#include "rom.h"

class PROM0Device : public IODevice
{
	using inherited = IODevice;
 public:
	PROM0Device();
	~PROM0Device() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr addr, uint32 data) override;
	busdata Peek1(uint32 addr) override;

 private:
	// アドレスデコーダ
	static uint32 Decoder(uint32 addr);

	// 書き込みの共通部分
	busdata Write();

	IODevice *prom {};
};

class PROMDevice : public ROMDevice
{
	using inherited = ROMDevice;
 public:
	PROMDevice();
	~PROMDevice() override;

	bool Init() override;

	uint GetROMVer() const { return romver; }

 private:
	bool InitLuna1();
	bool InitLuna88k();

	// PROM バージョン。
	// 100倍した整数形式で持つ。0 ならバージョン不明。
	uint romver {};
};

static inline PROM0Device *GetPROM0Device() {
	return Object::GetObject<PROM0Device>(OBJ_PROM_BOOT);
}

// PROM(現物)と ROMEMU の共通層である ROMDevice を返す。
// 区別が必要なら呼び出し側でもう一度 dynamic_cast<> すること。
static inline ROMDevice *GetPROMDevice() {
	return Object::GetObject<ROMDevice>(OBJ_PROM);
}
