//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// モニターウィンドウ
//

#pragma once

#include "wxsubwindow.h"
#include "wxtextscreen.h"
#include "wxscrollbar.h"

// モニタパネル
class WXMonitorPanel : public WXTextScreen
{
	using inherited = WXTextScreen;
 public:
	WXMonitorPanel(wxWindow *parent, Monitor *monitor_);
	~WXMonitorPanel() override;

	void FontChanged() override;

	// 画面を更新して再描画する。
	virtual void DoRefresh();

	// 更新頻度設定
	void SetRate(int hz);

	Monitor *GetMonitor() const { return monitor; }

 private:
	void OnTimer(wxTimerEvent&);

	Monitor *monitor {};
	wxTimer timer {};

	wxDECLARE_EVENT_TABLE();
};

// モニタウィンドウ (サイズ固定)
class WXMonitorWindow : public WXSubWindow
{
	using inherited = WXSubWindow;
 public:
	WXMonitorWindow(wxWindow *parent, const wxString& name,
		Monitor *monitor_);
	~WXMonitorWindow() override;

 protected:
	// モニタパネル
	WXMonitorPanel *monpanel {};
};

// 縦スクロールバー付きモニタウィンドウ
class WXScrollMonitorWindow : public WXSubWindow
{
	using inherited = WXSubWindow;
 public:
	WXScrollMonitorWindow(wxWindow *parent, const wxString& name,
		Monitor *monitor_);
	~WXScrollMonitorWindow() override;

	void FontChanged() override;
	bool Layout() override;

 private:
	bool GetMySizeHints(wxSize *, wxSize *, wxSize *, wxSize *) override;

	// マウスホイールイベント
	void OnMouseWheel(wxMouseEvent&);

	// スクロールイベント
	void OnScroll(wxScrollEvent& event);

	// スクロール処理
	void DoScroll(int pos);

	// モニタパネル
	WXMonitorPanel *monpanel {};

	// スクロールバー
	WXScrollBar *vscroll {};
};
