//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// NEWS のフレームバッファ(予定地)
//

#include "newsfb.h"
#include "monitor.h"

// コンストラクタ
NewsfbDevice::NewsfbDevice()
	: inherited(OBJ_NEWSFB)
{
	console.Init(80, 32, TextScreen::Console);

	monitor = gMonitorManager->Regist(ID_MONITOR_ROMCONS, this);
	monitor->SetCallback(&NewsfbDevice::MonitorScreen);
	monitor->SetSize(console.GetCol(), console.GetRow());
}

// デストラクタ
NewsfbDevice::~NewsfbDevice()
{
}

void
NewsfbDevice::ResetHard(bool poweron)
{
	console.Clear();
}

void
NewsfbDevice::Putc(int ch)
{
	if (ch == '\t') {
		// タブはここでスペースに展開
		int x = console.GetX();
		int next = roundup(x, 8);
		for (; x < next; x++) {
			console.Putc(' ');
		}
		return;
	}
	console.Putc(ch);
}

void
NewsfbDevice::MonitorScreen(Monitor *, TextScreen& screen)
{
	int row = console.GetRow();
	int col = console.GetCol();
	const auto& src = console.GetBuf();

	int s = 0;
	for (int y = 0; y < row; y++) {
		for (int x = 0; x < col; x++) {
			screen.Putc(x, y, src[s++]);
		}
	}
}
