//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// OPM (YM2151)
//

#pragma once

#include "device.h"

class ADPCMDevice;
class FDCDevice;

class OPMDevice : public IODevice
{
	using inherited = IODevice;

	static const uint32 baseaddr = 0xe90000;
	static const uint64 clk = 250_nsec;		// 4MHz

 public:
	OPMDevice();
	~OPMDevice() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

 protected:
	// BusIO インタフェース
	static const uint32 NPORT = 2;
	busdata ReadPort(uint32 offset);
	busdata WritePort(uint32 offset, uint32 data);
	busdata PeekPort(uint32 offset);
	bool PokePort(uint32 offset, uint32 data);

 private:
	bool IsBusy() const;

	int reg {};		// アクセスレジスタ番号

	uint64 busy_origin {};	// BUSY の起点時刻
	uint64 busy_start {};	// BUSY のアサート開始時刻
	uint64 busy_end {};		// BUSY のアサート終了時刻

	ADPCMDevice *adpcm {};
	FDCDevice *fdc {};
};
