//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// VM (X68030)
//

#include "vm_x68k.h"
#include "config.h"
#include "human68k.h"
#include "mainapp.h"
#include "mainbus_x68k.h"
#include "mpu680x0.h"
#include "nmi.h"
#include "power.h"
#include "renderer.h"
#include "sound.h"
#include "x68kkbd.h"

// コンストラクタ
VM_X68030::VM_X68030()
	: inherited("X68030")
{
	// 機種固有パラメータ

	// 実時間同期がちゃんと動作するにはゲスト OS の設定を要するため、
	// デフォルトは仮想時間同期にしておくほうがトラブルが少なそう。
	gConfig->SetDefault("clock-sync", "virtual");
	// MPU 種別。
	gConfig->SetDefault("mpu-type", "68030");
	// MPU クロックの初期値は機種ごとに異なる。単位は MHz
	gConfig->SetDefault("mpu-clock", 25);
	// RAM 初期値は MAX にしておく
	gConfig->SetDefault("ram-size", 12);

	// デバイス
	NEWDV(Power, new X68030PowerDevice());
	NEWDV(MPU, NewMPU680x0Device());
	NEWDV(Sound, new SoundRenderer());
	NEWDV(Mainbus, new X68kMainbus());
	NEWDV(Keyboard, new X68030Keyboard());
	NEWDV(NMI, new NMIDevice());
	NEWDV(Renderer, new X68030VideoRenderer());

	if (gMainApp.human_mode) {
		NEWDV(Human68k, new Human68kDevice());
	}

	// バーストアクセスなし (回路図より)
	auto mpu680x0 = GetMPU680x0Device(pMPU.get());
	if (mpu680x0) {
		mpu680x0->EnableBurstAccess(false);
	}
}

// デストラクタ
VM_X68030::~VM_X68030()
{
}
