//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// 独自ボタン
//

#pragma once

#include "wxtextpanel.h"

wxDECLARE_EVENT(NONO_EVT_BUTTON, wxCommandEvent);

class WXButton : public WXTextPanel
{
	using inherited = WXTextPanel;
 public:
	// 引数の並び順は標準スタイルとは変えてある
	WXButton(wxWindow *parent, wxWindowID id, const wxSize& size,
		const wxString& text_,
		const wxPoint& position = wxDefaultPosition);
	~WXButton() override;

	void FontChanged() override;
	void Fit() override;

	bool Enable(bool enable_) override;

 private:
	void OnSize(wxSizeEvent&);

	void OnMouse(wxMouseEvent& event);
	void OnTimer(wxTimerEvent& event);

	// ボタンが押されていれば true。
	bool IsPressed() const { return pressed; }

	// ボタンを押すか離した時の内部処理
	void Press(bool press);

	void Draw() override;

	// ボタン上のテキスト
	std::string sjistext {};

	// テキスト領域の大きさ
	wxSize textsize {};

	// テキスト描画開始の左上座標
	wxPoint textpos {};

	// ボタン押下中なら true
	bool pressed {};

	// キーリピート風動作のためのタイマーイベント
	wxTimer timer {};

	// イベントテーブル
	wxDECLARE_EVENT_TABLE();
};
