/*
 * Copyright (c) 2008-2025 Jonathan Schleifer <js@nil.im>
 *
 * All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3.0 only,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3.0 along with this program. If not, see
 * <https://www.gnu.org/licenses/>.
 */

#include "config.h"

#import "OFString.h"

#import "common.h"

const OFChar16 _OFCodepage852Table[] OF_VISIBILITY_HIDDEN = {
	0x00C7, 0x00FC, 0x00E9, 0x00E2, 0x00E4, 0x016F, 0x0107, 0x00E7,
	0x0142, 0x00EB, 0x0150, 0x0151, 0x00EE, 0x0179, 0x00C4, 0x0106,
	0x00C9, 0x0139, 0x013A, 0x00F4, 0x00F6, 0x013D, 0x013E, 0x015A,
	0x015B, 0x00D6, 0x00DC, 0x0164, 0x0165, 0x0141, 0x00D7, 0x010D,
	0x00E1, 0x00ED, 0x00F3, 0x00FA, 0x0104, 0x0105, 0x017D, 0x017E,
	0x0118, 0x0119, 0x00AC, 0x017A, 0x010C, 0x015F, 0x00AB, 0x00BB,
	0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x00C1, 0x00C2, 0x011A,
	0x015E, 0x2563, 0x2551, 0x2557, 0x255D, 0x017B, 0x017C, 0x2510,
	0x2514, 0x2534, 0x252C, 0x251C, 0x2500, 0x253C, 0x0102, 0x0103,
	0x255A, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256C, 0x00A4,
	0x0111, 0x0110, 0x010E, 0x00CB, 0x010F, 0x0147, 0x00CD, 0x00CE,
	0x011B, 0x2518, 0x250C, 0x2588, 0x2584, 0x0162, 0x016E, 0x2580,
	0x00D3, 0x00DF, 0x00D4, 0x0143, 0x0144, 0x0148, 0x0160, 0x0161,
	0x0154, 0x00DA, 0x0155, 0x0170, 0x00FD, 0x00DD, 0x0163, 0x00B4,
	0x00AD, 0x02DD, 0x02DB, 0x02C7, 0x02D8, 0x00A7, 0x00F7, 0x00B8,
	0x00B0, 0x00A8, 0x02D9, 0x0171, 0x0158, 0x0159, 0x25A0, 0x00A0
};
const size_t _OFCodepage852TableOffset OF_VISIBILITY_HIDDEN =
    256 - (sizeof(_OFCodepage852Table) / sizeof(*_OFCodepage852Table));

static const unsigned char page0[] = {
	0xFF, 0x00, 0x00, 0x00, 0xCF, 0x00, 0x00, 0xF5,
	0xF9, 0x00, 0x00, 0xAE, 0xAA, 0xF0, 0x00, 0x00,
	0xF8, 0x00, 0x00, 0x00, 0xEF, 0x00, 0x00, 0x00,
	0xF7, 0x00, 0x00, 0xAF, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xB5, 0xB6, 0x00, 0x8E, 0x00, 0x00, 0x80,
	0x00, 0x90, 0x00, 0xD3, 0x00, 0xD6, 0xD7, 0x00,
	0x00, 0x00, 0x00, 0xE0, 0xE2, 0x00, 0x99, 0x9E,
	0x00, 0x00, 0xE9, 0x00, 0x9A, 0xED, 0x00, 0xE1,
	0x00, 0xA0, 0x83, 0x00, 0x84, 0x00, 0x00, 0x87,
	0x00, 0x82, 0x00, 0x89, 0x00, 0xA1, 0x8C, 0x00,
	0x00, 0x00, 0x00, 0xA2, 0x93, 0x00, 0x94, 0xF6,
	0x00, 0x00, 0xA3, 0x00, 0x81, 0xEC
};
static const uint8_t page0Start = 0xA0;

static const unsigned char page1[] = {
	0xC6, 0xC7, 0xA4, 0xA5, 0x8F, 0x86, 0x00, 0x00,
	0x00, 0x00, 0xAC, 0x9F, 0xD2, 0xD4, 0xD1, 0xD0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA8, 0xA9,
	0xB7, 0xD8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x91,
	0x92, 0x00, 0x00, 0x95, 0x96, 0x00, 0x00, 0x9D,
	0x88, 0xE3, 0xE4, 0x00, 0x00, 0xD5, 0xE5, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8A, 0x8B,
	0x00, 0x00, 0xE8, 0xEA, 0x00, 0x00, 0xFC, 0xFD,
	0x97, 0x98, 0x00, 0x00, 0xB8, 0xAD, 0xE6, 0xE7,
	0xDD, 0xEE, 0x9B, 0x9C, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xDE, 0x85, 0xEB, 0xFB,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8D,
	0xAB, 0xBD, 0xBE, 0xA6, 0xA7
};
static const uint8_t page1Start = 0x02;

static const unsigned char page2[] = {
	0xF3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xF4, 0xFA, 0x00, 0xF2, 0x00, 0xF1
};
static const uint8_t page2Start = 0xC7;

static const unsigned char page25[] = {
	0xC4, 0x00, 0xB3, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xDA, 0x00, 0x00, 0x00,
	0xBF, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00,
	0xD9, 0x00, 0x00, 0x00, 0xC3, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xB4, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xC2, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xC1, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xC5, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xCD, 0xBA, 0x00, 0x00, 0xC9, 0x00, 0x00, 0xBB,
	0x00, 0x00, 0xC8, 0x00, 0x00, 0xBC, 0x00, 0x00,
	0xCC, 0x00, 0x00, 0xB9, 0x00, 0x00, 0xCB, 0x00,
	0x00, 0xCA, 0x00, 0x00, 0xCE, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xDF, 0x00, 0x00, 0x00, 0xDC, 0x00, 0x00, 0x00,
	0xDB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xB0, 0xB1, 0xB2, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xFE
};
static const uint8_t page25Start = 0x00;

bool OF_VISIBILITY_HIDDEN
_OFUnicodeToCodepage852(const OFUnichar *input, unsigned char *output,
    size_t length, bool lossy, bool insecure)
{
	for (size_t i = 0; i < length; i++) {
		OFUnichar c;

		if OF_UNLIKELY (!insecure && input[i] == 0)
			return false;

		c = input[i];

		if OF_UNLIKELY (c > 0x7F) {
			uint8_t idx;

			if OF_UNLIKELY (c > 0xFFFF) {
				if (lossy) {
					output[i] = '?';
					continue;
				} else
					return false;
			}

			switch (c >> 8) {
			CASE_MISSING_IS_ERROR(0)
			CASE_MISSING_IS_ERROR(1)
			CASE_MISSING_IS_ERROR(2)
			CASE_MISSING_IS_ERROR(25)
			default:
				if (lossy) {
					output[i] = '?';
					continue;
				} else
					return false;
			}
		} else
			output[i] = (unsigned char)c;
	}

	return true;
}
