use digest::{
    dev::{feed_rand_16mib, fixed_reset_test},
    hash_serialization_test, new_test,
};
use hex_literal::hex;
use sha2::{Digest, Sha224, Sha256, Sha384, Sha512, Sha512_224, Sha512_256};

new_test!(sha224_main, "sha224", Sha224, fixed_reset_test);
#[rustfmt::skip]
hash_serialization_test!(
    sha224_serializable_state,
    Sha224,
    hex!("
        347517c7066151018ff10a846ceff19c
        34cfae254e3efe284a6a92019582e270
        01000000000000001c01130000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000
    ")
);

new_test!(sha256_main, "sha256", Sha256, fixed_reset_test);
#[rustfmt::skip]
hash_serialization_test!(
    sha256_serializable_state,
    Sha256,
    hex!("
        ca01b8b161490f9889c64c64f9036cb7
        3322c40ec8c6a2d7da3ee8877247c253
        01000000000000002001130000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000
    ")
);

new_test!(sha512_224_main, "sha512_224", Sha512_224, fixed_reset_test);
#[rustfmt::skip]
hash_serialization_test!(
    sha512_224_serializable_state,
    Sha512_224,
    hex!("
        d9c911b44e2fe9546e6de18d6d4d7b40
        741b68eae6e6ad9d495d8ffbf3dec827
        66e8ef2f248f79b4a654fd4b04310088
        07b82e6616da4d4c7dc2fc45965c7381
        01000000000000000000000000000000
        1c011300000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        0000
    ")
);

new_test!(sha512_256_main, "sha512_256", Sha512_256, fixed_reset_test);
#[rustfmt::skip]
hash_serialization_test!(
    sha512_256_serializable_state,
    Sha512_256,
    hex!("
        7a37a8bf68012e540d93b77075bfff38
        af47e388f0be8293b1a2f112b8ca9f5c
        893499ddb32159a444c3c72e3b7194f5
        59d5625b73328dd3e8159273b77e7a98
        01000000000000000000000000000000
        20011300000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        0000
    ")
);

new_test!(sha384_main, "sha384", Sha384, fixed_reset_test);
#[rustfmt::skip]
hash_serialization_test!(
    sha384_serializable_state,
    Sha384,
    hex!("
        2a5aeaf34b33d4f3a8ba1a13b0ee48e7
        a3378b66f0bca73b4a576e84e7d1db0b
        43494cbd9a6b2e8c80e0703b605b8f82
        33ded6d375b39f7c18c80d3c0e9c7029
        01000000000000000000000000000000
        30011300000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        0000
    ")
);

new_test!(sha512_main, "sha512", Sha512, fixed_reset_test);
#[rustfmt::skip]
hash_serialization_test!(
    sha512_serializable_state,
    Sha512,
    hex!("
        eee700aeb8c1952696e5fb2c0701a728
        96937bc6a82e054e91e06fe939db2fa7
        e45494b888dc5090d16689284664e865
        0d06e4c18f4abb177d69d4fec184f8a4
        01000000000000000000000000000000
        40011300000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        00000000000000000000000000000000
        0000
    ")
);

#[test]
fn sha256_rand() {
    let mut h = Sha256::new();
    feed_rand_16mib(&mut h);
    assert_eq!(
        h.finalize(),
        hex!("45f51fead87328fe837a86f4f1ac0eb15116ab1473adc0423ef86c62eb2320c7"),
    );
}

#[test]
fn sha512_rand() {
    let mut h = Sha512::new();
    feed_rand_16mib(&mut h);
    assert_eq!(
        h.finalize(),
        hex!(
            "9084d75a7c0721541d737b6171eb465dc9ba08a119a182a8508484aa27a176cd"
            "e7c2103b108393eb024493ced4aac56be6f57222cac41b801f11494886264997"
        ),
    );
}
