<?php
require_once "class.test.php";
require_once INCLUDE_DIR."class.filter.php";
require_once INCLUDE_DIR."class.mailparse.php";

class MailBouncing extends Test {
    var $name = "Mail header tests";

    function testBounceHeaders() {
        static $headers = array(
            'Return-Path: <>',
            'From: Mail Delivery Subsystem <mailer-daemon@googlemail.com>',
            'X-Failed-Recipients: xxxxrack@xbsoxxxxxx.com',
            'Subject: Delivery Status Notification (Failure)',
            'From: MAILER-DAEMON@mail1.dl.supportsystem.com (Mail Delivery System)',
            'Subject: Undelivered Mail Returned to Sender',
            'Content-Type: multipart/report; report-type=delivery-status;
                boundary="6053C732A.7354145592/mail1.dl.supportsystem.com"',
        );
        foreach ($headers as $h)
            $this->assert(TicketFilter::isBounce($h), $h.": Unidentified bouce");
    }

    function testAutoReplyHeaders() {
        static $headers = array(
            'Auto-Submitted: auto-replied',
            'Precedence: auto_reply',
            'X-Precedence: auto_reply',
            'X-Autorespond: osTicket v1.8.0.2 Released',
            'Auto-Submitted: auto-generated',
            'X-Autogenerated: Reply',
        );
        foreach ($headers as $h)
            $this->assert(TicketFilter::isAutoReply($h),
                $h.": Unidentified auto-reply");
    }
}

return 'MailBouncing';
?>
