/*************************************************
*             MusicXML input for PMW             *
*************************************************/

/* Copyright (c) Philip Hazel, 2022 */
/* File last edited: May 2022 */

/* This module contains fixed XML data in the form of various tables */


#include "pmw.h"



/*************************************************
*  Tables of recognized elements and attributes  *
*************************************************/

/* The nocheck_attrs list is used for elements that are recognized, but
completely ignored. In the other lists, attributes that follow "**" are
kgnored. */

uschar *nocheck_attrs[]         = { US"*",          NULL };

uschar *accidental_attrs[]      = { US"parentheses", NULL };
uschar *accidental_mark_attrs[] = { US"placement",  US"**", US"default-x", US"default-y", NULL };
uschar *arpeggiate_attrs[]      = { US"**",         US"default-x", US"number", NULL };
uschar *articulation_attrs[]    = { US"placement",  US"type", US"**", US"default-x", US"default-y", NULL };
uschar *barline_attrs[]         = { US"location",   NULL };
uschar *beam_attrs[]            = { US"number",     NULL };
uschar *bracket_attrs[]         = { US"number",     US"type", US"line-end", US"line-type", US"default-y", US"relative-x", US"**", US"default-x", NULL };
uschar *clef_attrs[]            = { US"number",     NULL };
uschar *creator_attrs[]         = { US"type",       NULL };
uschar *credit_attrs[]          = { US"page",       NULL };
uschar *credit_words_attrs[]    = { US"font-size",  US"font-weight", US"justify", US"halign", US"valign", US"default-y", US"**", US"xml:space", US"xml:lang", US"default-x", US"font-family", US"letter-spacing", NULL };
uschar *dashes_attrs[]          = { US"type",       US"default-y", US"relative-x", US"**", US"default-x", NULL };
uschar *direction_attrs[]       = { US"directive",  US"placement",  NULL };
uschar *display_text_attrs[]    = { US"**",         US"xml:space", NULL };
uschar *dot_attrs[]             = { US"**",         US"relative-x", NULL };
uschar *down_bow_attrs[]        = { US"**",         US"default-x", US"default-y", US"placement", NULL };
uschar *dynamics_attrs[]        = { US"default-y",  US"halign", US"relative-x", US"**", US"default-x", NULL };
uschar *ending_attrs[]          = { US"number",     US"type", US"**", US"default-y", US"end-length", NULL };
uschar *extend_attrs[]          = { US"**",         US"type",  NULL };
uschar *fermata_attrs[]         = { US"type",       US"**", US"default-x", US"default-y", NULL };
uschar *grace_attrs[]           = { US"slash",      US"**", US"steal-time-following", NULL };
uschar *group_symbol_attrs[]    = { US"**",         US"default-x", NULL };
uschar *key_attrs[]             = { US"print-object", NULL };
uschar *lyric_attrs[]           = { US"justify",    US"relative-x", US"**",  US"default-y", US"number", NULL };
uschar *lyric_font_attrs[]      = { US"font-size",  US"**", US"font-family", NULL };
uschar *measure_attrs[]         = { US"implicit",   US"number",     US"width", NULL };
uschar *metronome_attrs[]       = { US"font-size",  US"parentheses", US"default-y", US"relative-y", US"**", US"font-family", US"default-x", NULL };
uschar *notehead_attrs[]        = { US"**",         US"filled", NULL };
uschar *note_attrs[]            = { US"default-x",  US"print-object", US"print-spacing", US"**", US"default-y", NULL };
uschar *offset_attrs[]          = { US"**",         US"sound", NULL };
uschar *page_margins_attrs[]    = { US"type",       NULL };
uschar *part_attrs[]            = { US"id",         NULL };
uschar *part_group_attrs[]      = { US"number",     US"type", NULL };
uschar *part_name_attrs[]       = { US"print-object", NULL };
uschar *pedal_attrs[]           = { US"line",       US"type", US"halign", US"default-y", US"relative-x", NULL };
uschar *print_attrs[]           = { US"new-system", US"**", US"new-page", US"page-number", NULL };
uschar *rehearsal_attrs[]       = { US"enclosure",  US"font-size", US"font-weight", US"default-x", US"default-y", NULL };
uschar *repeat_attrs[]          = { US"direction",  US"**", US"winged" };
uschar *rest_attrs[]            = { US"measure",    NULL };
uschar *score_part_attrs[]      = { US"id",         NULL };
uschar *score_partwise_attrs[]  = { US"version",    NULL };
uschar *slur_attrs[]            = { US"number",     US"placement", US"type", US"line-type", US"**", US"default-x", US"default-y", US"bezier-x", US"bezier-y", US"bezier-x2", US"bezier-y2", NULL };
uschar *staff_details_attrs[]   = { US"print-object", US"print-spacing", US"number", NULL };
uschar *staff_layout_attrs[]    = { US"number",     NULL };
uschar *stem_attrs[]            = { US"**",         US"default-y",  NULL };
uschar *tied_attrs[]            = { US"type",       US"orientation", NULL };
uschar *time_attrs[]            = { US"symbol",     NULL };
uschar *tremolo_attrs[]         = { US"type",       US"**", US"default-x", US"default-y", NULL };
uschar *trill_mark_attrs[]      = { US"**",         US"default-x", US"default-y", US"placement", NULL };
uschar *tuplet_attrs[]          = { US"bracket",    US"placement", US"type", US"show-number", US"**", US"number", NULL };
uschar *turn_attrs[]            = { US"placement",  US"slash", US"**", US"default-x", US"default-y", NULL };
uschar *type_attrs[]            = { US"size",       NULL };
uschar *up_bow_attrs[]          = { US"**",         US"default-x", US"default-y", US"placement", NULL };
uschar *wedge_attrs[]           = { US"type",       US"spread", US"default-y", US"relative-x", NULL };
uschar *words_attrs[]           = { US"font-size",  US"font-style", US"font-weight", US"enclosure", US"default-y", US"relative-x", US"relative-y", US"halign", US"**", US"default-x", US"xml:lang", NULL };
uschar *word_font_attrs[]       = { US"font-size",  US"**", US"font-family", NULL };


xml_elliststr xml_supported_elements[] = {
  { US"accent",                 articulation_attrs },
  { US"accidental",             accidental_attrs },
  { US"accidental-mark",        accidental_mark_attrs },
  { US"accidental-text",        NULL },
  { US"actual-notes",           NULL },
  { US"alter",                  nocheck_attrs },
  { US"appearance",             nocheck_attrs },
  { US"arpeggiate",             arpeggiate_attrs },
  { US"articulations",          NULL },
  { US"attributes",             NULL },
  { US"backup",                 NULL },
  { US"bar-style",              nocheck_attrs },
  { US"barline",                barline_attrs },
  { US"beam",                   beam_attrs },
  { US"beat-type",              NULL },
  { US"beat-unit",              NULL },
  { US"beats",                  NULL },
  { US"bottom-margin",          NULL },
  { US"bracket",                bracket_attrs },
  { US"breath-mark",            NULL },
  { US"caesura",                NULL },
  { US"chord",                  NULL },
  { US"chromatic",              nocheck_attrs },
  { US"clef",                   clef_attrs },
  { US"clef-octave-change",     NULL },
  { US"creator",                creator_attrs },
  { US"credit",                 credit_attrs },
  { US"credit-type",            NULL },
  { US"credit-words",           credit_words_attrs },
  { US"cue",                    NULL },
  { US"dashes",                 dashes_attrs },
  { US"defaults",               NULL },
  { US"delayed-turn",           turn_attrs },
  { US"detached-legato",        articulation_attrs },
  { US"diatonic",               nocheck_attrs },
  { US"direction",              direction_attrs },
  { US"direction-type",         NULL },
  { US"display-octave",         NULL },
  { US"display-step",           NULL },
  { US"display-text",           display_text_attrs },
  { US"distance",               nocheck_attrs },
  { US"divisions",              NULL },
  { US"doit",                   nocheck_attrs },
  { US"dot",                    dot_attrs },
  { US"down-bow",               down_bow_attrs },
  { US"duration",               nocheck_attrs },
  { US"dynamics",               dynamics_attrs },
  { US"encoding",               NULL },
  { US"encoding-date",          NULL },
  { US"end-line",               nocheck_attrs },
  { US"end-paragraph",          nocheck_attrs },
  { US"ending",                 ending_attrs },
  { US"ensemble",               nocheck_attrs },
  { US"extend",                 extend_attrs },
  { US"f",                      NULL },
  { US"falloff",                nocheck_attrs },
  { US"fermata",                fermata_attrs },
  { US"ff",                     NULL },
  { US"fifths",                 NULL },
  { US"forward",                NULL },
  { US"fp",                     NULL },
  { US"glyph",                  nocheck_attrs },
  { US"grace",                  grace_attrs },
  { US"group-abbreviation",     NULL },
  { US"group-abbreviation-display", NULL },
  { US"group-barline",          NULL },
  { US"group-name",             NULL },
  { US"group-name-display",     NULL },
  { US"group-symbol",           group_symbol_attrs },
  { US"identification",         NULL },
  { US"instrument",             nocheck_attrs },
  { US"instrument-name",        nocheck_attrs },
  { US"instrument-sound",       nocheck_attrs },
  { US"instruments",            nocheck_attrs },
  { US"key",                    key_attrs },
  { US"key-accidental",         NULL },
  { US"key-alter",              nocheck_attrs },
  { US"key-step",               NULL },
  { US"left-divider",           nocheck_attrs },
  { US"left-margin",            NULL },
  { US"line",                   NULL },
  { US"line-width",             nocheck_attrs },
  { US"lyric",                  lyric_attrs },
  { US"lyric-font",             lyric_font_attrs },
  { US"lyric-language",         nocheck_attrs },
  { US"measure",                measure_attrs },
  { US"measure-numbering",      NULL },
  { US"metronome",              metronome_attrs },
  { US"mf",                     NULL },
  { US"midi-channel",           nocheck_attrs },
  { US"midi-device",            nocheck_attrs },
  { US"midi-instrument",        nocheck_attrs },
  { US"midi-program",           nocheck_attrs },
  { US"midi-unpitched",         nocheck_attrs },
  { US"millimeters",            NULL },
  { US"mode",                   NULL },
  { US"movement-number",        nocheck_attrs },
  { US"movement-title",         NULL },
  { US"mp",                     NULL },
  { US"music-font",             nocheck_attrs },
  { US"normal-notes",           NULL },
  { US"normal-type",            nocheck_attrs },
  { US"notations",              NULL },
  { US"note",                   note_attrs },
  { US"note-size",              nocheck_attrs },
  { US"notehead",               notehead_attrs },
  { US"octave",                 NULL },
  { US"octave-change",          nocheck_attrs },
  { US"offset",                 offset_attrs },
  { US"ornaments",              NULL },
  { US"other-articulation",     nocheck_attrs },
  { US"other-direction",        nocheck_attrs },
  { US"p",                      NULL },
  { US"page-height",            NULL },
  { US"page-layout",            NULL },
  { US"page-margins",           page_margins_attrs },
  { US"page-width",             NULL },
  { US"pan",                    nocheck_attrs },
  { US"part",                   part_attrs },
  { US"part-abbreviation",      NULL },
  { US"part-abbreviation-display", NULL },
  { US"part-group",             part_group_attrs },
  { US"part-list",              NULL },
  { US"part-name",              part_name_attrs },
  { US"part-name-display",      NULL },
  { US"pedal",                  pedal_attrs },
  { US"per-minute",             NULL },
  { US"pitch",                  NULL },
  { US"plop",                   nocheck_attrs },
  { US"pp",                     NULL },
  { US"print",                  print_attrs },
  { US"rehearsal",              rehearsal_attrs },
  { US"repeat",                 repeat_attrs },
  { US"rest",                   rest_attrs },
  { US"right-divider",          nocheck_attrs },
  { US"right-margin",           NULL },
  { US"rights",                 NULL },
  { US"scaling",                NULL },
  { US"scoop",                  nocheck_attrs },
  { US"score-instrument",       nocheck_attrs },
  { US"score-part",             score_part_attrs },
  { US"score-partwise",         score_partwise_attrs },
  { US"sf",                     NULL },
  { US"sign",                   NULL },
  { US"slur",                   slur_attrs },
  { US"software",               nocheck_attrs },
  { US"solo",                   nocheck_attrs },
  { US"sound",                  nocheck_attrs },
  { US"spiccato",               articulation_attrs },
  { US"staccatissimo",          articulation_attrs },
  { US"staccato",               articulation_attrs },
  { US"staff",                  NULL },
  { US"staff-details",          staff_details_attrs },
  { US"staff-distance",         NULL },
  { US"staff-layout",           staff_layout_attrs },
  { US"staff-size",             NULL },
  { US"staves",                 NULL },
  { US"stem",                   stem_attrs },
  { US"step",                   NULL },
  { US"stress",                 nocheck_attrs },
  { US"strong-accent",          articulation_attrs },
  { US"supports",               nocheck_attrs },
  { US"syllabic",               NULL },
  { US"system-distance",        NULL },
  { US"system-dividers",        NULL },
  { US"system-layout",          NULL },
  { US"system-margins",         NULL },
  { US"technical",              NULL },
  { US"tenths",                 NULL },
  { US"tenuto",                 articulation_attrs },
  { US"text",                   NULL },
  { US"tie",                    nocheck_attrs },
  { US"tied",                   tied_attrs },
  { US"time",                   time_attrs },
  { US"time-modification",      NULL },
  { US"top-margin",             NULL },
  { US"top-system-distance",    NULL },
  { US"transpose",              nocheck_attrs },
  { US"tremolo",                tremolo_attrs },
  { US"trill-mark",             trill_mark_attrs },
  { US"tuplet",                 tuplet_attrs },
  { US"turn",                   turn_attrs },
  { US"type",                   type_attrs },
  { US"unpitched",              NULL },
  { US"unstress",               nocheck_attrs },
  { US"up-bow",                 up_bow_attrs },
  { US"voice",                  nocheck_attrs },
  { US"volume",                 nocheck_attrs },
  { US"wedge",                  wedge_attrs },
  { US"word-font",              word_font_attrs },
  { US"words",                  words_attrs },
  { US"work",                   NULL },
  { US"work-number",            NULL },
  { US"work-title",             NULL },
};

int xml_supported_elements_count =
  sizeof(xml_supported_elements)/sizeof(xml_elliststr);



/*************************************************
*         Tables of named XML entities           *
*************************************************/

/* This table must be in collating sequence of entity name, because it is
searched by binary chop. */

xml_entity_block xml_entity_list[] = {
  { US"AElig",             0x00c6u },
  { US"Aacute",            0x00c1u },
  { US"Abreve",            0x0102u },
  { US"Acirc",             0x00c2u },
  { US"Agrave",            0x00c0u },
  { US"Amacr",             0x0100u },
  { US"Aogon",             0x0104u },
  { US"Aring",             0x00c5u },
  { US"Atilde",            0x00c3u },
  { US"Auml",              0x00c4u },
  { US"Cacute",            0x0106u },
  { US"Ccaron",            0x010cu },
  { US"Ccedil",            0x00c7u },
  { US"Ccirc",             0x0108u },
  { US"Cdot",              0x010au },
  { US"Dagger",            0x2021u },
  { US"Dcaron",            0x010eu },
  { US"Dstrok",            0x0110u },
  { US"ENG",               0x014au },
  { US"ETH",               0x00d0u },
  { US"Eacute",            0x00c9u },
  { US"Ecaron",            0x011au },
  { US"Ecirc",             0x00cau },
  { US"Edot",              0x0116u },
  { US"Egrave",            0x00c8u },
  { US"Emacr",             0x0112u },
  { US"Eogon",             0x0118u },
  { US"Euml",              0x00cbu },
  { US"Euro",              0x20acu },
  { US"Gbreve",            0x011eu },
  { US"Gcedil",            0x0122u },
  { US"Gcirc",             0x011cu },
  { US"Gdot",              0x0120u },
  { US"Hcirc",             0x0124u },
  { US"Hstrok",            0x0126u },
  { US"IJlig",             0x0132u },
  { US"Iacute",            0x00cdu },
  { US"Icirc",             0x00ceu },
  { US"Idot",              0x0130u },
  { US"Igrave",            0x00ccu },
  { US"Imacr",             0x012au },
  { US"Iogon",             0x012eu },
  { US"Itilde",            0x0128u },
  { US"Iuml",              0x00cfu },
  { US"Jcirc",             0x0134u },
  { US"Kcedil",            0x0136u },
  { US"Lacute",            0x0139u },
  { US"Lcaron",            0x013du },
  { US"Lcedil",            0x013bu },
  { US"Lmidot",            0x013fu },
  { US"Lstrok",            0x0141u },
  { US"Nacute",            0x0143u },
  { US"Ncaron",            0x0147u },
  { US"Ncedil",            0x0145u },
  { US"Ntilde",            0x00d1u },
  { US"OElig",             0x0152u },
  { US"Oacute",            0x00d3u },
  { US"Ocirc",             0x00d4u },
  { US"Odblac",            0x0150u },
  { US"Ograve",            0x00d2u },
  { US"Omacr",             0x014cu },
  { US"Oslash",            0x00d8u },
  { US"Otilde",            0x00d5u },
  { US"Ouml",              0x00d6u },
  { US"Racute",            0x0154u },
  { US"Rcaron",            0x0158u },
  { US"Rcedil",            0x0156u },
  { US"Sacute",            0x015au },
  { US"Scaron",            0x0160u },
  { US"Scedil",            0x015eu },
  { US"Scirc",             0x015cu },
  { US"THORN",             0x00deu },
  { US"Tcaron",            0x0164u },
  { US"Tcedil",            0x0162u },
  { US"Tstrok",            0x0166u },
  { US"Uacute",            0x00dau },
  { US"Ubreve",            0x016cu },
  { US"Ucirc",             0x00dbu },
  { US"Udblac",            0x0170u },
  { US"Ugrave",            0x00d9u },
  { US"Umacr",             0x016au },
  { US"Uogon",             0x0172u },
  { US"Uring",             0x016eu },
  { US"Utilde",            0x0168u },
  { US"Uuml",              0x00dcu },
  { US"Wcirc",             0x0174u },
  { US"Yacute",            0x00ddu },
  { US"Ycirc",             0x0176u },
  { US"Yuml",              0x0178u },
  { US"Zacute",            0x0179u },
  { US"Zcaron",            0x017du },
  { US"Zdot",              0x017bu },
  { US"aacute",            0x00e1u },
  { US"abreve",            0x0103u },
  { US"acirc",             0x00e2u },
  { US"aelig",             0x00e6u },
  { US"agrave",            0x00e0u },
  { US"amacr",             0x0101u },
  { US"amp",               0x0026u },
  { US"aogon",             0x0105u },
  { US"apos",              0x0027u },
  { US"aring",             0x00e5u },
  { US"atilde",            0x00e3u },
  { US"auml",              0x00e4u },
  { US"blank",             0x2423u },
  { US"blk12",             0x2592u },
  { US"blk14",             0x2591u },
  { US"blk34",             0x2593u },
  { US"block",             0x2588u },
  { US"brvbar",            0x00a6u },
  { US"bull",              0x2022u },
  { US"cacute",            0x0107u },
  { US"caret",             0x2041u },
  { US"ccaron",            0x010du },
  { US"ccedil",            0x00e7u },
  { US"ccirc",             0x0109u },
  { US"cdot",              0x010bu },
  { US"cent",              0x00a2u },
  { US"check",             0x2713u },
  { US"cir",               0x25cbu },
  { US"clubs",             0x2663u },
  { US"copy",              0x00a9u },
  { US"copysr",            0x2117u },
  { US"cross",             0x2717u },
  { US"curren",            0x00a4u },
  { US"dagger",            0x2020u },
  { US"darr",              0x2193u },
  { US"dash",              0x2010u },
  { US"dcaron",            0x010fu },
  { US"deg",               0x00b0u },
  { US"diams",             0x2666u },
  { US"divide",            0x00f7u },
  { US"dlcrop",            0x230du },
  { US"drcrop",            0x230cu },
  { US"dstrok",            0x0111u },
  { US"dtri",              0x25bfu },
  { US"dtrif",             0x25beu },
  { US"eacute",            0x00e9u },
  { US"ecaron",            0x011bu },
  { US"ecirc",             0x00eau },
  { US"edot",              0x0117u },
  { US"egrave",            0x00e8u },
  { US"emacr",             0x0113u },
  { US"eng",               0x014bu },
  { US"eogon",             0x0119u },
  { US"eth",               0x00f0u },
  { US"euml",              0x00ebu },
  { US"female",            0x2640u },
  { US"ffilig",            0xfb03u },
  { US"fflig",             0xfb00u },
  { US"ffllig",            0xfb04u },
  { US"filig",             0xfb01u },
  { US"flat",              0x266du },
  { US"fllig",             0xfb02u },
  { US"frac12",            0x00bdu },
  { US"frac13",            0x2153u },
  { US"frac14",            0x00bcu },
  { US"frac15",            0x2155u },
  { US"frac16",            0x2159u },
  { US"frac18",            0x215bu },
  { US"frac23",            0x2154u },
  { US"frac25",            0x2156u },
  { US"frac34",            0x00beu },
  { US"frac35",            0x2157u },
  { US"frac38",            0x215cu },
  { US"frac45",            0x2158u },
  { US"frac56",            0x215au },
  { US"frac58",            0x215du },
  { US"frac78",            0x215eu },
  { US"gacute",            0x01f5u },
  { US"gbreve",            0x011fu },
  { US"gcirc",             0x011du },
  { US"gdot",              0x0121u },
  { US"gt",                0x003eu },
  { US"half",              0x00bdu },
  { US"hcirc",             0x0125u },
  { US"hearts",            0x2665u },
  { US"hellip",            0x2026u },
  { US"horbar",            0x2015u },
  { US"hstrok",            0x0127u },
  { US"hybull",            0x2043u },
  { US"iacute",            0x00edu },
  { US"icirc",             0x00eeu },
  { US"iexcl",             0x00a1u },
  { US"igrave",            0x00ecu },
  { US"ijlig",             0x0133u },
  { US"imacr",             0x012bu },
  { US"incare",            0x2105u },
  { US"inodot",            0x0131u },
  { US"iogon",             0x012fu },
  { US"iquest",            0x00bfu },
  { US"itilde",            0x0129u },
  { US"iuml",              0x00efu },
  { US"jcirc",             0x0135u },
  { US"kcedil",            0x0137u },
  { US"kgreen",            0x0138u },
  { US"lacute",            0x013au },
  { US"laquo",             0x00abu },
  { US"larr",              0x2190u },
  { US"lcaron",            0x013eu },
  { US"lcedil",            0x013cu },
  { US"ldquo",             0x201cu },
  { US"ldquor",            0x201eu },
  { US"lhblk",             0x2584u },
  { US"lmidot",            0x0140u },
  { US"loz",               0x25cau },
  { US"lsquo",             0x2018u },
  { US"lsquor",            0x201au },
  { US"lstrok",            0x0142u },
  { US"lt",                0x003cu },
  { US"ltri",              0x25c3u },
  { US"ltrif",             0x25c2u },
  { US"male",              0x2642u },
  { US"malt",              0x2720u },
  { US"marker",            0x25aeu },
  { US"mdash",             0x2014u },
  { US"micro",             0x00b5u },
  { US"middot",            0x00b7u },
  { US"mldr",              0x2026u },
  { US"nacute",            0x0144u },
  { US"napos",             0x0149u },
  { US"natur",             0x266eu },
  { US"nbsp",              0x00a0u },
  { US"ncaron",            0x0148u },
  { US"ncedil",            0x0146u },
  { US"ndash",             0x2013u },
  { US"nldr",              0x2025u },
  { US"not",               0x00acu },
  { US"ntilde",            0x00f1u },
  { US"oacute",            0x00f3u },
  { US"ocirc",             0x00f4u },
  { US"odblac",            0x0151u },
  { US"oelig",             0x0153u },
  { US"ograve",            0x00f2u },
  { US"ohm",               0x2126u },
  { US"omacr",             0x014du },
  { US"ordf",              0x00aau },
  { US"ordm",              0x00bau },
  { US"oslash",            0x00f8u },
  { US"otilde",            0x00f5u },
  { US"ouml",              0x00f6u },
  { US"para",              0x00b6u },
  { US"phone",             0x260eu },
  { US"plusmn",            0x00b1u },
  { US"pound",             0x00a3u },
  { US"quot",              0x0022u },
  { US"racute",            0x0155u },
  { US"raquo",             0x00bbu },
  { US"rarr",              0x2192u },
  { US"rcaron",            0x0159u },
  { US"rcedil",            0x0157u },
  { US"rdquo",             0x201du },
  { US"rdquor",            0x201du },
  { US"rect",              0x25adu },
  { US"reg",               0x00aeu },
  { US"rsquo",             0x2019u },
  { US"rsquor",            0x2019u },
  { US"rtri",              0x25b9u },
  { US"rtrif",             0x25b8u },
  { US"rx",                0x211eu },
  { US"sacute",            0x015bu },
  { US"scaron",            0x0161u },
  { US"scedil",            0x015fu },
  { US"scirc",             0x015du },
  { US"sect",              0x00a7u },
  { US"sext",              0x2736u },
  { US"sharp",             0x266fu },
  { US"shy",               0x00adu },
  { US"spades",            0x2660u },
  { US"squ",               0x25a1u },
  { US"squf",              0x25aau },
  { US"sup1",              0x00b9u },
  { US"sup2",              0x00b2u },
  { US"sup3",              0x00b3u },
  { US"szlig",             0x00dfu },
  { US"target",            0x2316u },
  { US"tcaron",            0x0165u },
  { US"tcedil",            0x0163u },
  { US"telrec",            0x2315u },
  { US"thorn",             0x00feu },
  { US"times",             0x00d7u },
  { US"trade",             0x2122u },
  { US"tstrok",            0x0167u },
  { US"uacute",            0x00fau },
  { US"uarr",              0x2191u },
  { US"ubreve",            0x016du },
  { US"ucirc",             0x00fbu },
  { US"udblac",            0x0171u },
  { US"ugrave",            0x00f9u },
  { US"uhblk",             0x2580u },
  { US"ulcrop",            0x230fu },
  { US"umacr",             0x016bu },
  { US"uogon",             0x0173u },
  { US"urcrop",            0x230eu },
  { US"uring",             0x016fu },
  { US"utilde",            0x0169u },
  { US"utri",              0x25b5u },
  { US"utrif",             0x25b4u },
  { US"uuml",              0x00fcu },
  { US"vellip",            0x22eeu },
  { US"wcirc",             0x0175u },
  { US"yacute",            0x00fdu },
  { US"ycirc",             0x0177u },
  { US"yen",               0x00a5u },
  { US"yuml",              0x00ffu },
  { US"zacute",            0x017au },
  { US"zcaron",            0x017eu },
  { US"zdot",              0x017cu }
};

int xml_entity_list_count = sizeof(xml_entity_list)/sizeof(xml_entity_block);

/* End of xml_tables.c */
