---
authors: "sosukesuzuki"
title: "Prettier 2.4: new bracketSameLine option and TypeScript 4.4 support!"
---

This release renames the `jsxBracketSameLine` option to `bracketSameLine`, which supports HTML, Vue, and Angular in addition to JSX. The old name has been deprecated.

We’ve also added support for [TypeScript 4.4](https://www.typescriptlang.org/docs/handbook/release-notes/typescript-4-4.html), including new syntax features such as [class `static` blocks](https://github.com/tc39/proposal-class-static-block).

If you enjoy Prettier and would like to support our work, consider sponsoring us directly via [our OpenCollective](https://opencollective.com/prettier) or by sponsoring the projects we depend on, including [typescript-eslint](https://opencollective.com/typescript-eslint), [remark](https://opencollective.com/unified), and [Babel](https://opencollective.com/babel).

<!-- truncate -->

## Highlights

### TypeScript

#### Support TypeScript 4.4 ([#11426](https://github.com/prettier/prettier/pull/11426) by [@sosukesuzuki](https://github.com/sosukesuzuki))

Support [TypeScript 4.4](https://devblogs.microsoft.com/typescript/announcing-typescript-4-4/)!

##### [`static` Blocks in Classes](https://devblogs.microsoft.com/typescript/announcing-typescript-4-4/#static-blocks)

Class Static Blocks syntax is a Stage 4 ECMAScript proposal. See https://github.com/tc39/proposal-class-static-block for more details.

<!-- prettier-ignore -->
```tsx
// Input
class Foo {
  static count = 0;

  // This is a static block:
  static {
    if (someCondition()) {
      Foo.count++;
    }
  }
}

// Prettier 2.3
SyntaxError: Declaration expected. (5:9)
  3 |
  4 |   // This is a static block:
> 5 |   static {
    |         ^
  6 |     if (someCondition()) {
  7 |       Foo.count++;
  8 |     }

// Prettier 2.4
class Foo {
  static count = 0;

  // This is a static block:
  static {
    if (someCondition()) {
      Foo.count++;
    }
  }
}

```

### HTML

#### Replace `jsxBracketSameLine` option with `bracketSameLine` option ([#11006](https://github.com/prettier/prettier/pull/11006) by [@kurtztech](https://github.com/kurtztech))

Deprecate the `jsxBracketSameLine` option in favour of the new `bracketSameLine` option that will work for HTML, Angular, Vue, and JSX.

<!-- prettier-ignore -->
```html
<!-- Input -->
<div id="foo-bar-baz"
  class="bar-foo-baz"
  title="a sample title"
  data-foo="bar"
  data-bar="baz">lorem ipsum dolor sit amet</div>

<!-- Prettier 2.3 -->
<div
  id="foo-bar-baz"
  class="bar-foo-baz"
  title="a sample title"
  data-foo="bar"
  data-bar="baz"
>
  lorem ipsum dolor sit amet
</div>

<!-- Prettier 2.4 -->
<!-- Options: `{bracketSameLine: true}` -->
<div
  id="foo-bar-baz"
  class="bar-foo-baz"
  title="a sample title"
  data-foo="bar"
  data-bar="baz">
  lorem ipsum dolor sit amet
</div>
```

## Other Changes

### JavaScript

#### Support parenthesized tagged template literals for styled components ([#11246](https://github.com/prettier/prettier/pull/11246) by [@sosukesuzuki](https://github.com/sosukesuzuki))

<!-- prettier-ignore -->
```js
// Input
const StyledComponent =
  /** @type {import('styled-components').ThemedStyledFunction<'div',null,{overlap: boolean}>} */
  (styled.div)`
    position:   fixed;
  color: red;
  `;

// Prettier 2.3
const StyledComponent =
  /** @type {import('styled-components').ThemedStyledFunction<'div',null,{overlap: boolean}>} */
  (styled.div)`
    position:   fixed;
  color: red;
  `;

// Prettier 2.4
const StyledComponent =
  /** @type {import('styled-components').ThemedStyledFunction<'div',null,{overlap: boolean}>} */
  (styled.div)`
    position: fixed;
    color: red;
  `;

```

#### Count correctly regex literals in method chain arguments ([#11299](https://github.com/prettier/prettier/pull/11299) by [@sosukesuzuki](https://github.com/sosukesuzuki))

<!-- prettier-ignore -->
```js
// Input
foo1(/𠮟𠮟𠮟/).foo2(bar).foo3(baz);

foo1(/叱叱叱/).foo2(bar).foo3(baz);

// Prettier 2.3
foo1(/𠮟𠮟𠮟/)
  .foo2(bar)
  .foo3(baz);

foo1(/叱叱叱/).foo2(bar).foo3(baz);

// Prettier 2.4
foo1(/𠮟𠮟𠮟/)
  .foo2(bar)
  .foo3(baz);

foo1(/叱叱叱/)
  .foo2(bar)
  .foo3(baz);

```

#### Support hack-style pipeline proposal ([#11335](https://github.com/prettier/prettier/pull/11335) by [@sosukesuzuki](https://github.com/sosukesuzuki))

The proposed [hack-style pipeline syntax](https://github.com/js-choi/proposal-hack-pipes) is now supported by Prettier. We are using `%` as the topic token, following the official explainer — although this may change in future releases as the proposal progresses.

As part of this change, support for the [“smart” pipeline syntax](https://github.com/js-choi/proposal-smart-pipelines) has been removed. See [our policy on non-standardized syntax](https://prettier.io/docs/rationale#disclaimer-about-non-standard-syntax) for the rationale behind this decision.

```js
// Input
const foo = fn() |> fn1(%) |> fn2(%);

// Prettier 2.3
SyntaxError: Unexpected token (1:25)
> 1 | const foo = fn() |> fn1(%) |> fn2(%);
    |                         ^
  2 |

// Prettier 2.4
const foo = fn() |> fn1(%) |> fn(%);

```

### TypeScript

#### Fix formatting intersection types that include mapped types ([#11247](https://github.com/prettier/prettier/pull/11247) by [@sosukesuzuki](https://github.com/sosukesuzuki))

<!-- prettier-ignore -->
```ts
// Input
type Example = {
  [A in B]: T;
} & {
  [A in B]: T;
};

// Prettier 2.3
type Example = {
  [A in B]: T;
} &
  {
    [A in B]: T;
  };

// Prettier 2.4
type Example = {
  [A in B]: T;
} & {
  [A in B]: T;
};

```

### Flow

#### Always put a semicolon before Flow variance sigils ([#11398](https://github.com/prettier/prettier/pull/11398) by [@noppa](https://github.com/noppa))

<!-- prettier-ignore -->
```jsx
// Input
class A {
  +one = function() {};
  -two = val();
  +#privOne = val();
  static +#privTwo = val();
}
// Prettier 2.3
class A {
  +one = function() {}
  -two = val()
  +#privOne = val()
  static +#privTwo = val()
}
// Prettier 2.4
class A {
  +one = function() {};
  -two = val();
  +#privOne = val()
  static +#privTwo = val()
}
```

### SCSS

#### Consistently quote Sass modules strings ([#11461](https://github.com/prettier/prettier/pull/11461) by [@niksy](https://github.com/niksy))

<!-- prettier-ignore -->
```scss
// Input
@use "sass:math";
@forward "list";

// Prettier 2.3
@use "sass:math";
@forward "list";

// Prettier 2.4
@use 'sass:math';
@forward 'list';
```

### CLI

#### Infer parser for `.stylelintrc` ([#10924](https://github.com/prettier/prettier/pull/10924) by [@SevenOutman](https://github.com/SevenOutman))

A `.stylelintrc` file (without extension) is handled using `json` and `yaml` parsers.
