# This file is auto-generated by /codegen/x86_64.py
# Instruction data is based on package opcodes 0.3.14

import inspect

import peachpy.stream
import peachpy.x86_64.options
import peachpy.x86_64.isa
from peachpy.util import is_sint8, is_sint32
from peachpy.x86_64.encoding import rex, optional_rex, vex2, vex3, evex, modrm_sib_disp
from peachpy.x86_64.instructions import Instruction, BranchInstruction
from peachpy.x86_64.operand import is_al, is_ax, is_eax, is_rax, is_cl, is_xmm0, is_r8, is_r8rex, is_r16, is_r32, is_r64, \
    is_mm, is_xmm, is_ymm, is_m, is_m8, is_m16, is_m32, is_m64, is_m80, is_m128, is_m256, is_m512, \
    is_evex_xmm, is_xmmk, is_xmmkz, is_evex_ymm, is_ymmk, is_ymmkz, is_zmm, is_zmmk, is_zmmkz, is_k, is_kk, \
    is_m32k, is_m64k, is_m16kz, is_m32kz, is_m64kz, is_m128kz, is_m256kz, is_m512kz, \
    is_m64_m32bcst, is_m128_m32bcst, is_m256_m32bcst, is_m512_m32bcst, \
    is_m128_m64bcst, is_m256_m64bcst, is_m512_m64bcst, \
    is_vmx, is_vmy, is_evex_vmx, is_evex_vmy, is_vmz, is_vmxk, is_vmyk, is_vmzk, \
    is_imm, is_imm4, is_imm8, is_imm16, is_imm32, is_imm64, \
    is_rel8, is_rel32, is_label, is_er, is_sae, check_operand, format_operand_type


class KADDB(Instruction):
    """ADD Two 8-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KADDB(k, k, k)    [AVX512DQ]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KADDB, self).__init__("KADDB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KADDB\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, 0, None, op[1].hlcode, vex3) + bytearray([0x4A, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        else:
            raise SyntaxError("Invalid operand types: KADDB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KADDW(Instruction):
    """ADD Two 16-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KADDW(k, k, k)    [AVX512DQ]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KADDW, self).__init__("KADDW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KADDW\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(4, 0, None, op[1].hlcode, vex3) + bytearray([0x4A, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        else:
            raise SyntaxError("Invalid operand types: KADDW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KADDD(Instruction):
    """ADD Two 32-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KADDD(k, k, k)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KADDD, self).__init__("KADDD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KADDD\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1, 0xFD ^ (op[1].hlcode << 3), 0x4A, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KADDD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KADDQ(Instruction):
    """ADD Two 64-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KADDQ(k, k, k)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KADDQ, self).__init__("KADDQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KADDQ\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1, 0xFC ^ (op[1].hlcode << 3), 0x4A, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KADDQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KANDB(Instruction):
    """Bitwise Logical AND 8-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KANDB(k, k, k)    [AVX512DQ]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KANDB, self).__init__("KANDB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KANDB\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, 0, None, op[1].hlcode, vex3) + bytearray([0x41, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        else:
            raise SyntaxError("Invalid operand types: KANDB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KANDW(Instruction):
    """Bitwise Logical AND 16-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KANDW(k, k, k)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KANDW, self).__init__("KANDW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KANDW\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(4, 0, None, op[1].hlcode, vex3) + bytearray([0x41, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: KANDW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KANDD(Instruction):
    """Bitwise Logical AND 32-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KANDD(k, k, k)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KANDD, self).__init__("KANDD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KANDD\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1, 0xFD ^ (op[1].hlcode << 3), 0x41, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KANDD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KANDQ(Instruction):
    """Bitwise Logical AND 64-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KANDQ(k, k, k)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KANDQ, self).__init__("KANDQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KANDQ\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1, 0xFC ^ (op[1].hlcode << 3), 0x41, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KANDQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KANDNB(Instruction):
    """Bitwise Logical AND NOT 8-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KANDNB(k, k, k)    [AVX512DQ]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KANDNB, self).__init__("KANDNB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KANDNB\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, 0, None, op[1].hlcode, vex3) + bytearray([0x42, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        else:
            raise SyntaxError("Invalid operand types: KANDNB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KANDNW(Instruction):
    """Bitwise Logical AND NOT 16-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KANDNW(k, k, k)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KANDNW, self).__init__("KANDNW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KANDNW\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(4, 0, None, op[1].hlcode, vex3) + bytearray([0x42, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: KANDNW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KANDND(Instruction):
    """Bitwise Logical AND NOT 32-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KANDND(k, k, k)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KANDND, self).__init__("KANDND", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KANDND\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1, 0xFD ^ (op[1].hlcode << 3), 0x42, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KANDND " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KANDNQ(Instruction):
    """Bitwise Logical AND NOT 64-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KANDNQ(k, k, k)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KANDNQ, self).__init__("KANDNQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KANDNQ\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1, 0xFC ^ (op[1].hlcode << 3), 0x42, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KANDNQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KORB(Instruction):
    """Bitwise Logical OR 8-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KORB(k, k, k)    [AVX512DQ]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KORB, self).__init__("KORB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KORB\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, 0, None, op[1].hlcode, vex3) + bytearray([0x45, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        else:
            raise SyntaxError("Invalid operand types: KORB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KORW(Instruction):
    """Bitwise Logical OR 16-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KORW(k, k, k)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KORW, self).__init__("KORW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KORW\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(4, 0, None, op[1].hlcode, vex3) + bytearray([0x45, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: KORW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KORD(Instruction):
    """Bitwise Logical OR 32-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KORD(k, k, k)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KORD, self).__init__("KORD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KORD\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1, 0xFD ^ (op[1].hlcode << 3), 0x45, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KORD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KORQ(Instruction):
    """Bitwise Logical OR 64-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KORQ(k, k, k)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KORQ, self).__init__("KORQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KORQ\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1, 0xFC ^ (op[1].hlcode << 3), 0x45, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KORQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KXNORB(Instruction):
    """Bitwise Logical XNOR 8-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KXNORB(k, k, k)    [AVX512DQ]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KXNORB, self).__init__("KXNORB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KXNORB\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, 0, None, op[1].hlcode, vex3) + bytearray([0x46, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        else:
            raise SyntaxError("Invalid operand types: KXNORB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KXNORW(Instruction):
    """Bitwise Logical XNOR 16-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KXNORW(k, k, k)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KXNORW, self).__init__("KXNORW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KXNORW\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(4, 0, None, op[1].hlcode, vex3) + bytearray([0x46, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: KXNORW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KXNORD(Instruction):
    """Bitwise Logical XNOR 32-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KXNORD(k, k, k)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KXNORD, self).__init__("KXNORD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KXNORD\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1, 0xFD ^ (op[1].hlcode << 3), 0x46, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KXNORD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KXNORQ(Instruction):
    """Bitwise Logical XNOR 64-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KXNORQ(k, k, k)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KXNORQ, self).__init__("KXNORQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KXNORQ\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1, 0xFC ^ (op[1].hlcode << 3), 0x46, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KXNORQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KXORB(Instruction):
    """Bitwise Logical XOR 8-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KXORB(k, k, k)    [AVX512DQ]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KXORB, self).__init__("KXORB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KXORB\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, 0, None, op[1].hlcode, vex3) + bytearray([0x47, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        else:
            raise SyntaxError("Invalid operand types: KXORB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KXORW(Instruction):
    """Bitwise Logical XOR 16-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KXORW(k, k, k)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KXORW, self).__init__("KXORW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KXORW\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(4, 0, None, op[1].hlcode, vex3) + bytearray([0x47, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: KXORW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KXORD(Instruction):
    """Bitwise Logical XOR 32-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KXORD(k, k, k)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KXORD, self).__init__("KXORD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KXORD\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1, 0xFD ^ (op[1].hlcode << 3), 0x47, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KXORD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KXORQ(Instruction):
    """Bitwise Logical XOR 64-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KXORQ(k, k, k)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KXORQ, self).__init__("KXORQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KXORQ\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1, 0xFC ^ (op[1].hlcode << 3), 0x47, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KXORQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KMOVB(Instruction):
    """Move 8-bit Mask"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KMOVB(k, k)      [AVX512DQ]
            * KMOVB(k, m8)     [AVX512DQ]
            * KMOVB(k, r32)    [AVX512DQ]
            * KMOVB(m8, k)     [AVX512DQ]
            * KMOVB(r32, k)    [AVX512DQ]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KMOVB, self).__init__("KMOVB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"KMOVB\" requires 2 operands")
        self.out_operands = (True, False)
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        if is_k(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, 0, None, 0, vex3) + bytearray([0x90, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_k(self.operands[0]) and is_r32(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, 0, op[1], 0, vex3) + bytearray([0x92, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_k(self.operands[0]) and is_m8(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, 0, op[1].address, 0, vex3) + bytearray([0x90]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_r32(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, None, 0, vex3) + bytearray([0x93, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_m8(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, 0, op[0].address, 0, vex3) + bytearray([0x91]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
        else:
            raise SyntaxError("Invalid operand types: KMOVB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KMOVW(Instruction):
    """Move 16-bit Mask"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KMOVW(k, k)      [AVX512F]
            * KMOVW(k, m16)    [AVX512F]
            * KMOVW(k, r32)    [AVX512F]
            * KMOVW(m16, k)    [AVX512F]
            * KMOVW(r32, k)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KMOVW, self).__init__("KMOVW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"KMOVW\" requires 2 operands")
        self.out_operands = (True, False)
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        if is_k(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(0, 0, None, 0, vex3) + bytearray([0x90, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_k(self.operands[0]) and is_r32(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(0, 0, op[1], 0, vex3) + bytearray([0x92, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_k(self.operands[0]) and is_m16(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, 0, op[1].address, 0, vex3) + bytearray([0x90]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_r32(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, None, 0, vex3) + bytearray([0x93, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_m16(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, 0, op[0].address, 0, vex3) + bytearray([0x91]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
        else:
            raise SyntaxError("Invalid operand types: KMOVW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KMOVD(Instruction):
    """Move 32-bit Mask"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KMOVD(k, k)          [AVX512BW]
            * KMOVD(k, r32/m32)    [AVX512BW]
            * KMOVD(r32/m32, k)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KMOVD, self).__init__("KMOVD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"KMOVD\" requires 2 operands")
        self.out_operands = (True, False)
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        if is_k(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1, 0xF9, 0x90, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_k(self.operands[0]) and is_r32(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(3, 0, op[1], 0, vex3) + bytearray([0x92, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_k(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b1, 0x81, 0, op[1].address) + bytearray([0x90]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_r32(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(3, op[0].hcode, None, 0, vex3) + bytearray([0x93, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_m32(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b1, 0x81, 0, op[0].address) + bytearray([0x91]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
        else:
            raise SyntaxError("Invalid operand types: KMOVD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KMOVQ(Instruction):
    """Move 64-bit Mask"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KMOVQ(k, k)          [AVX512BW]
            * KMOVQ(k, r64/m64)    [AVX512BW]
            * KMOVQ(r64/m64, k)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KMOVQ, self).__init__("KMOVQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"KMOVQ\" requires 2 operands")
        self.out_operands = (True, False)
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        if is_k(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1, 0xF8, 0x90, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_k(self.operands[0]) and is_r64(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1 ^ (op[1].hcode << 5), 0xFB, 0x92, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_k(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b1, 0x80, 0, op[1].address) + bytearray([0x90]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_r64(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1 ^ (op[0].hcode << 7), 0xFB, 0x93, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_m64(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b1, 0x80, 0, op[0].address) + bytearray([0x91]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
        else:
            raise SyntaxError("Invalid operand types: KMOVQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KNOTB(Instruction):
    """NOT 8-bit Mask Register"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KNOTB(k, k)    [AVX512DQ]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KNOTB, self).__init__("KNOTB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"KNOTB\" requires 2 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, 0, None, 0, vex3) + bytearray([0x44, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.out_operands = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        else:
            raise SyntaxError("Invalid operand types: KNOTB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KNOTW(Instruction):
    """NOT 16-bit Mask Register"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KNOTW(k, k)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KNOTW, self).__init__("KNOTW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"KNOTW\" requires 2 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(0, 0, None, 0, vex3) + bytearray([0x44, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.out_operands = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: KNOTW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KNOTD(Instruction):
    """NOT 32-bit Mask Register"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KNOTD(k, k)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KNOTD, self).__init__("KNOTD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"KNOTD\" requires 2 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1, 0xF9, 0x44, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.out_operands = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KNOTD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KNOTQ(Instruction):
    """NOT 64-bit Mask Register"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KNOTQ(k, k)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KNOTQ, self).__init__("KNOTQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"KNOTQ\" requires 2 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1, 0xF8, 0x44, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.out_operands = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KNOTQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KUNPCKBW(Instruction):
    """Unpack and Interleave 8-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KUNPCKBW(k, k, k)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KUNPCKBW, self).__init__("KUNPCKBW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KUNPCKBW\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, 0, None, op[1].hlcode, vex3) + bytearray([0x4B, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: KUNPCKBW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KUNPCKWD(Instruction):
    """Unpack and Interleave 16-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KUNPCKWD(k, k, k)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KUNPCKWD, self).__init__("KUNPCKWD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KUNPCKWD\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(4, 0, None, op[1].hlcode, vex3) + bytearray([0x4B, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KUNPCKWD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KUNPCKDQ(Instruction):
    """Unpack and Interleave 32-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KUNPCKDQ(k, k, k)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KUNPCKDQ, self).__init__("KUNPCKDQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KUNPCKDQ\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_k(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1, 0xFC ^ (op[1].hlcode << 3), 0x4B, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KUNPCKDQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KTESTB(Instruction):
    """Bit Test 8-bit Masks and Set Flags"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KTESTB(k, k)    [AVX512DQ]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KTESTB, self).__init__("KTESTB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"KTESTB\" requires 2 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, 0, None, 0, vex3) + bytearray([0x99, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.out_operands = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        else:
            raise SyntaxError("Invalid operand types: KTESTB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KTESTW(Instruction):
    """Bit Test 16-bit Masks and Set Flags"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KTESTW(k, k)    [AVX512DQ]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KTESTW, self).__init__("KTESTW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"KTESTW\" requires 2 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(0, 0, None, 0, vex3) + bytearray([0x99, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.out_operands = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        else:
            raise SyntaxError("Invalid operand types: KTESTW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KTESTD(Instruction):
    """Bit Test 32-bit Masks and Set Flags"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KTESTD(k, k)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KTESTD, self).__init__("KTESTD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"KTESTD\" requires 2 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1, 0xF9, 0x99, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.out_operands = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KTESTD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KTESTQ(Instruction):
    """Bit Test 64-bit Masks and Set Flags"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KTESTQ(k, k)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KTESTQ, self).__init__("KTESTQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"KTESTQ\" requires 2 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1, 0xF8, 0x99, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.out_operands = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KTESTQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KORTESTB(Instruction):
    """OR 8-bit Masks and Set Flags"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KORTESTB(k, k)    [AVX512DQ]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KORTESTB, self).__init__("KORTESTB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"KORTESTB\" requires 2 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, 0, None, 0, vex3) + bytearray([0x98, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.out_operands = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        else:
            raise SyntaxError("Invalid operand types: KORTESTB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KORTESTW(Instruction):
    """OR 16-bit Masks and Set Flags"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KORTESTW(k, k)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KORTESTW, self).__init__("KORTESTW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"KORTESTW\" requires 2 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(0, 0, None, 0, vex3) + bytearray([0x98, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.out_operands = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: KORTESTW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KORTESTD(Instruction):
    """OR 32-bit Masks and Set Flags"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KORTESTD(k, k)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KORTESTD, self).__init__("KORTESTD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"KORTESTD\" requires 2 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1, 0xF9, 0x98, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.out_operands = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KORTESTD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KORTESTQ(Instruction):
    """OR 64-bit Masks and Set Flags"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KORTESTQ(k, k)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KORTESTQ, self).__init__("KORTESTQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"KORTESTQ\" requires 2 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1, 0xF8, 0x98, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.out_operands = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KORTESTQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KSHIFTLB(Instruction):
    """Shift Left 8-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KSHIFTLB(k, k, imm8)    [AVX512DQ]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KSHIFTLB, self).__init__("KSHIFTLB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KSHIFTLB\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3, 0x79, 0x32, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        else:
            raise SyntaxError("Invalid operand types: KSHIFTLB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KSHIFTLW(Instruction):
    """Shift Left 16-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KSHIFTLW(k, k, imm8)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KSHIFTLW, self).__init__("KSHIFTLW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KSHIFTLW\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3, 0xF9, 0x32, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: KSHIFTLW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KSHIFTLD(Instruction):
    """Shift Left 32-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KSHIFTLD(k, k, imm8)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KSHIFTLD, self).__init__("KSHIFTLD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KSHIFTLD\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3, 0x79, 0x33, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KSHIFTLD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KSHIFTLQ(Instruction):
    """Shift Left 64-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KSHIFTLQ(k, k, imm8)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KSHIFTLQ, self).__init__("KSHIFTLQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KSHIFTLQ\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3, 0xF9, 0x33, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KSHIFTLQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KSHIFTRB(Instruction):
    """Shift Right 8-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KSHIFTRB(k, k, imm8)    [AVX512DQ]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KSHIFTRB, self).__init__("KSHIFTRB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KSHIFTRB\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3, 0x79, 0x30, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        else:
            raise SyntaxError("Invalid operand types: KSHIFTRB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KSHIFTRW(Instruction):
    """Shift Right 16-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KSHIFTRW(k, k, imm8)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KSHIFTRW, self).__init__("KSHIFTRW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KSHIFTRW\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3, 0xF9, 0x30, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: KSHIFTRW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KSHIFTRD(Instruction):
    """Shift Right 32-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KSHIFTRD(k, k, imm8)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KSHIFTRD, self).__init__("KSHIFTRD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KSHIFTRD\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3, 0x79, 0x31, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KSHIFTRD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class KSHIFTRQ(Instruction):
    """Shift Right 64-bit Masks"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * KSHIFTRQ(k, k, imm8)    [AVX512BW]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(KSHIFTRQ, self).__init__("KSHIFTRQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"KSHIFTRQ\" requires 3 operands")
        if is_k(self.operands[0]) and is_k(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3, 0xF9, 0x31, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: KSHIFTRQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


