/*
 * Copyright (c) 2009, 2010 Nhat Minh Lê
 * Copyright (c) 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * For non-NetBSD systems.
 */

#ifndef REGXML_COMPAT_H
#define REGXML_COMPAT_H

/*
 * <sys/cdefs.h> compatibily.
 */
#include <sys/cdefs.h>

#ifndef _DIAGASSERT
#define _DIAGASSERT assert
#endif

#ifndef __UNCONST
#define __UNCONST(x) ((void *)(x))
#endif

#ifndef __arraycount
#define __arraycount(x) (sizeof (x) / sizeof (x)[0])
#endif


/*
 * <sys/queue.h> compatibily.
 */
#include <sys/queue.h>

/*
 * Simple queue definitions.
 */
#ifndef SIMPLEQ_HEAD
#define	SIMPLEQ_HEAD(name, type)					\
struct name {								\
	struct type *sqh_first;	/* first element */			\
	struct type **sqh_last;	/* addr of last next element */		\
}
#endif

#ifndef SIMPLEQ_HEAD_INITIALIZER
#define	SIMPLEQ_HEAD_INITIALIZER(head)					\
	{ NULL, &(head).sqh_first }
#endif

#ifndef SIMPLEQ_ENTRY
#define	SIMPLEQ_ENTRY(type)						\
struct {								\
	struct type *sqe_next;	/* next element */			\
}
#endif

/*
 * Simple queue functions.
 */
#ifndef SIMPLEQ_INIT
#define	SIMPLEQ_INIT(head) do {						\
	(head)->sqh_first = NULL;					\
	(head)->sqh_last = &(head)->sqh_first;				\
} while (/*CONSTCOND*/0)
#endif

#ifndef SIMPLEQ_INSERT_HEAD
#define	SIMPLEQ_INSERT_HEAD(head, elm, field) do {			\
	if (((elm)->field.sqe_next = (head)->sqh_first) == NULL)	\
		(head)->sqh_last = &(elm)->field.sqe_next;		\
	(head)->sqh_first = (elm);					\
} while (/*CONSTCOND*/0)
#endif

#ifndef SIMPLEQ_INSERT_TAIL
#define	SIMPLEQ_INSERT_TAIL(head, elm, field) do {			\
	(elm)->field.sqe_next = NULL;					\
	*(head)->sqh_last = (elm);					\
	(head)->sqh_last = &(elm)->field.sqe_next;			\
} while (/*CONSTCOND*/0)
#endif

#ifndef SIMPLEQ_INSERT_AFTER
#define	SIMPLEQ_INSERT_AFTER(head, listelm, elm, field) do {		\
	if (((elm)->field.sqe_next = (listelm)->field.sqe_next) == NULL)\
		(head)->sqh_last = &(elm)->field.sqe_next;		\
	(listelm)->field.sqe_next = (elm);				\
} while (/*CONSTCOND*/0)
#endif

#ifndef SIMPLEQ_REMOVE_HEAD
#define	SIMPLEQ_REMOVE_HEAD(head, field) do {				\
	if (((head)->sqh_first = (head)->sqh_first->field.sqe_next) == NULL) \
		(head)->sqh_last = &(head)->sqh_first;			\
} while (/*CONSTCOND*/0)
#endif

#ifndef SIMPLEQ_REMOVE
#define	SIMPLEQ_REMOVE(head, elm, type, field) do {			\
	if ((head)->sqh_first == (elm)) {				\
		SIMPLEQ_REMOVE_HEAD((head), field);			\
	} else {							\
		struct type *curelm = (head)->sqh_first;		\
		while (curelm->field.sqe_next != (elm))			\
			curelm = curelm->field.sqe_next;		\
		if ((curelm->field.sqe_next =				\
			curelm->field.sqe_next->field.sqe_next) == NULL) \
			    (head)->sqh_last = &(curelm)->field.sqe_next; \
	}								\
} while (/*CONSTCOND*/0)
#endif

#ifndef SIMPLEQ_FOREACH
#define	SIMPLEQ_FOREACH(var, head, field)				\
	for ((var) = ((head)->sqh_first);				\
		(var);							\
		(var) = ((var)->field.sqe_next))
#endif

/*
 * Simple queue access methods.
 */
#ifndef SIMPLEQ_EMPTY
#define	SIMPLEQ_EMPTY(head)		((head)->sqh_first == NULL)
#endif
#ifndef SIMPLEQ_FIRST
#define	SIMPLEQ_FIRST(head)		((head)->sqh_first)
#endif
#ifndef SIMPLEQ_NEXT
#define	SIMPLEQ_NEXT(elm, field)	((elm)->field.sqe_next)
#endif


/*
 * XXX: Move these declarations elsewhere? They are not directly
 * needed by the library.
 */
__BEGIN_DECLS
const char *getprogname(void);
void setprogname(const char *);
__END_DECLS

#endif	/* !REGXML_COMPAT_H */
