/*****************************************************/
/* Image avec effet d'eau                            */
/* image_water.h                                     */
/*                                                   */
/* Ecrit par : Daniel Lacroix (all rights reserved)  */
/*                                                   */
/*****************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <image_draw_func.h>
#include <image_water.h>
#include <color.h>

uint32 water_width,water_height;
int32  *water_buf1, *water_buf2;

void water_init(uint32 width, uint32 height)
{ image vimage;

  water_width  = width;
  water_height = height;

  if((water_buf1 = (int32 *)malloc(width*height*sizeof(int32))) == NULL)
  { perror("malloc failed "); exit(1); }
  
  if((water_buf2 = (int32 *)malloc(width*height*sizeof(int32))) == NULL)
  { perror("malloc failed "); exit(1); }

  vimage.width  = width;
  vimage.height = height;
  vimage.buf = (pix *)water_buf1;
  ellipse_fill_alpha_replace(&vimage, width/2, height/2, width/4, height/4, WHITE);
  ellipse_fill_alpha_replace(&vimage, width/6, height/8, width/8, height/8, BLUE);
  vimage.buf = (pix *)water_buf2;  
  ellipse_fill_alpha_replace(&vimage, width/2, height/2, width/4, height/4, WHITE);
  ellipse_fill_alpha_replace(&vimage, width/6, height/8, width/8, height/8, BLUE);
}

void water_close(void)
{
  free(water_buf1); free(water_buf2);
}

void water_next(void)
{ int32 *water_buf_tmp;
  int32 x,y;

  /* inverse les 2 buffers. */  
  water_buf_tmp = water_buf1;
  water_buf1 = water_buf2;
  water_buf2 = water_buf_tmp;
  
  /* la nouvelle "image" sera dans water_buf1 */
  for(y = 1; y < water_height-1; y++)
  {
    for(x = 1; x < water_width-1; x++/*, x++, x++*/)
    { 
/*      water_buf1[(y*water_width)+x] = -2000000000;
      water_buf1[(y*water_width)+x+1] = 0;
      water_buf1[(y*water_width)+x+2] = +2000000000;
*/
      water_buf1[(y*water_width)+x] = water_buf2[(y*water_width)+x];
/*      water_buf1[(y*water_width)+x] = 
        ((water_buf2[((y-1)*water_width)+x] +
          water_buf2[((y+1)*water_width)+x] +
          water_buf2[((y)*water_width)+x-1] +
          water_buf2[((y)*water_width)+x+1])>>1) -
        water_buf1[((y)*water_width)+x];

      water_buf1[(y*water_width)+x] -= 
        water_buf1[(y*water_width)+x] >> 4;
*/
    }
  }
}

image *image_water_new(void)
{ image *vimage;
  int32 x,y;
  int32 offsetx,offsety;
  float light;

  vimage = image_new(water_width, water_height);

  for(y = 1; y < water_height-1; y++)
  {
    for(x = 1; x < water_width-1; x++)
    {
      offsetx = (water_buf1[(y*water_width)+x]>>1) - (water_buf1[((y+1)*water_width)+x]>>1);
      offsety = (water_buf1[(y*water_width)+x]>>1) - (water_buf1[(y*water_width)+x+1]>>1);

      light = (((float)((offsetx>>1) + (offsety>>1)))/((float)(1<<31))) + 0.5;

      light = ((float)((uint32)water_buf1[(y*water_width)+x])) / ((float)(1<<31));

      light = MIN(1.0,light);
      
      vimage->buf[(y*water_width)+x] = COL(
        (uint8)(light * 0.3 * 255.0),
        (uint8)(light * 0.4 * 255.0),
        (uint8)(light * 1.0 * 255.0)
      );
      
/*      vimage->buf[(y*water_width)+x].r = (128 +
        (offsetx/2 + offsety/2)>>25) * 0.3;

      vimage->buf[(y*water_width)+x].g = (128 +
        (offsetx/2 + offsety/2)>>25) * 0.4;

      vimage->buf[(y*water_width)+x].b = (128 +
        (offsetx/2 + offsety/2)>>25) * 1.0;*/
    }
/*    printf("\n");*/
  }
  return(vimage);
}

image *image_floue_new(image *pimage)
{ image *vimage;
  int32 x,y;

  vimage = image_new(pimage->width, pimage->height);

  for(y = 1; y < pimage->height-1; y++)
  {
    for(x = 1; x < pimage->width-1; x++)
    {
      vimage->buf[(y*vimage->width)+x] = COL(
        ((COL_RED(pimage->buf[((y-1)*pimage->width)+x]) +
          COL_RED(pimage->buf[((y+1)*pimage->width)+x]) +
          COL_RED(pimage->buf[((y)*pimage->width)+x-1]) +
          COL_RED(pimage->buf[((y)*pimage->width)+x+1]))>>2),
        ((COL_GREEN(pimage->buf[((y-1)*pimage->width)+x]) +
          COL_GREEN(pimage->buf[((y+1)*pimage->width)+x]) +
          COL_GREEN(pimage->buf[((y)*pimage->width)+x-1]) +
          COL_GREEN(pimage->buf[((y)*pimage->width)+x+1]))>>2),
        ((COL_BLUE(pimage->buf[((y-1)*pimage->width)+x]) +
          COL_BLUE(pimage->buf[((y+1)*pimage->width)+x]) +
          COL_BLUE(pimage->buf[((y)*pimage->width)+x-1]) +
          COL_BLUE(pimage->buf[((y)*pimage->width)+x+1]))>>2)
      );
    }
  }
  return(vimage);
}
