#ifndef ROBODOC_CONFIG_H
#define ROBODOC_CONFIG_H

typedef enum
{
    CFL_REMARK = 0,
    CFL_PARAMETER,
    CFL_SECTION,
    CFL_EMPTYLINE,
    CFL_UNKNOWN
} T_Line_Kind;

typedef enum
{
    SK_ITEMS = 0,
    SK_IGNOREITEMS,
    SK_OPTIONS,
    SK_EXTENSIONS,  /* Obsolete */
    SK_HEADERTYPES,
    SK_IGNORE_FILES,
    SK_ACCEPT_FILES,
    SK_HEADER_MARKERS,
    SK_REMARK_MARKERS,
    SK_END_MARKERS,
    SK_UNKNOWN
} T_Block_Kind;


/****s* Configuration/Parameters
 * FUNCTION
 *    Structure to store all the paramters found in a block in the
 *    robodoc configuation file.
 * ATTRIBUTES
 *    o number -- the number of parameters found.
 *    o size   -- the maximum size of the names array.
 *    o names  -- an array with the values of the parameters.
 * NOTES
 *    Find a better name for the attribute 'names'
 * SOURCE
 */

struct Parameters {
    int        number;
    int        size;
    char              **names;  
};

/*****/


/****s* Configuration/RB_Configuration
 * FUNCTION
 *   All the data from the robodoc.rc file is stored in this
 *   structure.
 * ATTRIBUTES
 *   o items           -- an array with names that robodoc recognizes as
 *                      items.  Alsways includes the name "SOURCE" as
 *                      the first element.
 *   o ignore_items    -- an array with the names of items that ROBODoc
 *                      should ignore.
 *   o options         -- Array with all options specified both on the
 *                      commandline as well as in the robodoc.rc file.
 *   o custom_headertypes -- list with custom header types.
 *   o ignore_files    -- list with wildcard expressions that specifies
 *                      files and directories that robodoc should skip
 *                      while scanning the source tree.
 *   o header_markers  -- 
 *   o remark_markers  --
 *   o end_markers     --
 * SOURCE
 */

struct RB_Configuration
{
    struct Parameters   items;
    struct Parameters   ignore_items;
    struct Parameters   options;
    struct Parameters   custom_headertypes;
    struct Parameters   ignore_files;
    struct Parameters   accept_files;
    struct Parameters   header_markers;
    struct Parameters   remark_markers;
    struct Parameters   end_markers;
};

/*******/

char               *RB_GetParameter_Old( char *line );
void                RB_GetParameter( char *line, struct Parameters* parameters );
void                RB_ReadConfiguration( unsigned int argc, char **argv, char* filename );
void                RB_Free_Configuration( void );

extern struct RB_Configuration configuration;

#endif
