/****h* ROBODoc/Test_Generator
 * FUNCTION
 *   The generator for test output.
 *
 *   The purpose of this generator is to create output that is easily
 *   scanable by the system test scripts.  This to make it easier to
 *   write tests for ROBODoc.
 *
 * MODIFICATION HISTORY
 *   * 2004-05-20   Frans Slothouber  V1.0
 *******
 * $Id: test_generator.c,v 1.1 2004/06/13 20:46:02 gumpu Exp $
 */


#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <ctype.h>
#include "test_generator.h"
#include "globals.h"
#include "util.h"


char               *
RB_TEST_Get_Default_Extension( void )
{
    return ".tst";
}

void
RB_TEST_Generate_String( FILE * dest_doc, char *a_string )
{
    int                 i;
    int                 l = strlen( a_string );
    unsigned char       c;

    for ( i = 0; i < l; ++i )
    {
        c = a_string[i];
        RB_TEST_Generate_Char( dest_doc, c );
    }
}

/* TODO Documentation */

void
RB_TEST_Generate_Label( FILE* dest_doc, char *name )
{
    int                 i;
    int                 l = strlen( name );
    unsigned char       c;

    fprintf( dest_doc, "LABEL " );
    for ( i = 0; i < l; ++i )
    {
        c = name[i];
        if ( isalnum( c) ) 
        {
            RB_TEST_Generate_Char( dest_doc, c );
        }
        else
        {
            char buf[4];
            sprintf(buf, "%02x", c );
            RB_TEST_Generate_Char( dest_doc, buf[0] );
            RB_TEST_Generate_Char( dest_doc, buf[1] );
        }
    }
    fprintf( dest_doc, "\n" );
}


/****f* Generator/RB_TEST_Generate_Char
 * NAME
 *   RB_TEST_Generate_Char
 * SYNOPSIS
 *   void RB_TEST_Generate_Char( FILE * dest_doc, int c )
 * FUNCTION
 *   Switchboard to RB_TEST_Generate_Char
 * SOURCE
 */

void
RB_TEST_Generate_Char( FILE * dest_doc, int c )
{
    switch ( c )
    {
        default:
            RB_FputcLatin1ToUtf8( dest_doc, c );
            break;
    }
}

/*****/

void
RB_TEST_Generate_Header_Start( FILE * dest_doc,
                                struct RB_header *cur_header )
{
    fprintf( dest_doc, "HEADER_START " );
    RB_TEST_Generate_String( dest_doc, cur_header->name );
    fprintf( dest_doc, "\n" );
}

void
RB_TEST_Generate_Header_End( FILE * dest_doc, struct RB_header *cur_header )
{
    fprintf( dest_doc, "HEADER_END\n" );
}

void
RB_TEST_Generate_Link( FILE * dest, char *dest_name, char *filename,
                        char *labelname, char *linkname, int in_fold )
{
    fprintf( dest, "LINK (%s) (", labelname );
    RB_TEST_Generate_String( dest, linkname );
    fprintf( dest, ")\n" );
}

void
RB_TEST_Generate_Doc_Start( FILE * dest_doc, char *src_name, char *name,
                             char toc )
{

    if ( course_of_action & DO_HEADLESS ) 
    {
        /* The user does not want the document head. */
    }
    else
    {
        fprintf( dest_doc, "DOC_START (%s) (%s)\n", src_name, name );
    }
}


void
RB_TEST_Generate_Doc_End( FILE * dest_doc, char *name )
{
    if ( course_of_action & DO_FOOTLESS ) 
    {
        /* The user does not want the foot of the
         * document.
         */
    }
    else
    {
        fprintf( dest_doc, "%s", "DOC_END\n" );
    }
}


void
RB_TEST_Generate_Item_Name( FILE * dest_doc, char *name )
{
    fprintf( dest_doc, "ITEM_NAME " );
    RB_TEST_Generate_String( dest_doc, name );
    fprintf( dest_doc, "\n" );
}

void
RB_TEST_Generate_Item_Begin( FILE* dest_doc )
{
    fprintf( dest_doc, "ITEM_BEGIN\n" );
}


void
RB_TEST_Generate_Item_End( FILE * dest_doc )
{
    fprintf( dest_doc, "ITEM_END\n" );
}


void
RB_TEST_Generate_BeginSection( FILE * dest_doc, int depth, char *name )
{
    fprintf( dest_doc, "BEGIN_SECTION ");
    RB_TEST_Generate_String( dest_doc, name );
    fprintf( dest_doc, "\n" );
}

void
RB_TEST_Generate_EndSection( FILE * dest_doc, int depth, char *name )
{
    fprintf( dest_doc, "END_SECTION " );
    RB_TEST_Generate_String( dest_doc, name );
    fprintf( dest_doc, "\n" );
}


void
RB_TEST_Generate_False_Link( FILE * dest_doc, char *name )
{
    RB_TEST_Generate_String( dest_doc, name );
}



void TEST_Generate_Begin_Paragraph( FILE* dest_doc )
{
    fprintf( dest_doc, "BEGIN_PARA\n" );
}

void TEST_Generate_End_Paragraph( FILE* dest_doc )
{
    fprintf( dest_doc, "END_PARA\n" );
}


void TEST_Generate_Begin_Preformatted( FILE* dest_doc )
{
    fprintf( dest_doc, "BEGIN_PRE\n" );
}

void TEST_Generate_End_Preformatted( FILE* dest_doc )
{
    fprintf( dest_doc, "END_PRE\n" );
}


void TEST_Generate_Begin_List( FILE* dest_doc )
{
    fprintf( dest_doc, "BEGIN_LIST\n" );
}

void TEST_Generate_End_List( FILE* dest_doc )
{
    fprintf( dest_doc, "END_LIST\n" );
}

void TEST_Generate_Begin_List_Item( FILE* dest_doc )
{
    fprintf( dest_doc, "BEGIN_LIST_ITEM\n" );
}

void TEST_Generate_End_List_Item( FILE* dest_doc )
{
    fprintf( dest_doc, "END_LIST_ITEM\n" );
}


