#!@SH@
#
# @(#)tallyho.sh,v 1.2 2004/04/23 06:14:32 kim Exp
#
# Analyses the output of tally to produce total volume by hierarchy.
# -0 produces the analysis by group, -1 goes one level down into the
# hierarchies, -2 goes 2 levels down, -3 goes three levels down.
# -r rounds to the next highest kilobyte rather than using exact byte counts.
# Mark Moraes, University of Toronto
#
PATH=@BINDIR@:@PREFIX@/bin:/bin:/usr/bin:/usr/sbin
export PATH
#
spool=/proj/news/spool
prefix=
#prefix="$spool/"	# for B News and old C news systems.
sedcmd="s,\([^/]*\).*/[0-9][0-9]*,\1,"
roundit=0
while :
do
	case "$1" in
	-r)	roundit=1023; shift;;
	-1)	shift;;
	-0)	sedcmd="s,\(.*\)/[0-9][0-9]*,\1,"; shift;;
	-2)	sedcmd="s,\([^/]*/[^/]*\).*/[0-9][0-9]*,\1,
			s,\([^/]*\).*/[0-9][0-9]*,\1,"; shift;;
	-3)	sedcmd="s,\([^/]*/[^/]*/[^/]*\).*/[0-9][0-9]*,\1,
			s,\([^/]*/[^/]*\).*/[0-9][0-9]*,\1,
			s,\([^/]*\).*/[0-9][0-9]*,\1,"; shift;;
	*)	break;;
	esac
done
sed "$sedcmd" $@ |
	tr / . |
	awk 'BEGIN {
		roundit = '"$roundit"';
	}
	{
		hc[$1]++;
		nc++;
		x = ($2 + roundit) / 1024;
		h[$1] += x;
		n += x;
	}
	END {
		print "cat << \\EOF";
		printf "%40.40s %8s %8s %8s\n\n", "Hierarchy", "Kbytes", "# arts.", "Kb/art"
		printf "%40.40s %8d %8d %8.3f\n\n", "Total", n, nc, n / nc;
		print "EOF"
		print "sort -nr +1 << \\EOF"
		for (i in h)
			printf "%40.40s %8d %8d %8.3f\n", i, h[i], hc[i], h[i]/hc[i];
		print "EOF"
	}' |
	sh
exit	
case "$1" in
-0)	cat <<- EOF
	s,\(.*\)/$end,\1,
	EOF
	shift;;
-1)	shift;;
-2)	cat << - EOF
	s,pat='[^/]*/[^[/]*'; shift;;
-3)	pat='[^/]*/[^[/]*/[^[/]*'; shift;;
-4)	pat='[^/]*/[^[/]*/[^[/]*/[^[/]*'; shift;;
esac
