/*
 * Copyright (C) 2002 WIDE Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#define	S_TOSEND	1
#define	S_TORECV	2
#define	S_RECVD		3
#define	S_TIMEDOUT	4
#define	S_ERROR		5

#define	DNSPORT		53

#define	INTERVAL_ROOT	300
#define	INTERVAL_CCTLD	7200
#define	QI_MIN		3
#define	QI_MAX		7
#define	MAX_TIMEOUT	60
#define	MAX_DURATION	14	/* days */

#define	END_OF_PROVE
#define	REALADDRPORT	599
#define	REALADDRSERV	"203.178.136.36"
#define	CHECKINTERVAL	600	/* minimum to iflist/realaddr check */

#define	PROJECT_FINISH	1072915200	/* 2004 Jan 1 00:00:00 GMT */

#define	IPADDRLEN	16	/* strlen("255.255.255.255") + 1 */

#define	REPORTADDR	"dnsprobe@wide.ad.jp"
#ifdef __CYGWIN__
#define	MAILER		"/usr/sbin/ssmtp.exe"
#else
#define MAILER		"/usr/bin/mail"
#endif

#define DEFAULT_HOSTNAME "www.ietf.org"

struct server {
	char *servername;
	char *serveraddr;
	int so;
	u_short id;
	u_short state;
	struct sockaddr_in dst;
	struct sockaddr_in src;
	char ifname[IFNAMSIZ];
	struct timeval tv;
	struct timeval tv_sent;
	u_long rtt;	/* rtt in msec */
	int s_rcode;
	int s_errno;
	char realsrc[IPADDRLEN];
};

struct server rootservers[] = {
	{ "A", "198.41.0.4",     0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "B", "128.9.0.107",    0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "C", "192.33.4.12",    0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "D", "128.8.10.90",    0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "E", "192.203.230.10", 0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "F", "192.5.5.241",    0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "G", "192.112.36.4",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "H", "128.63.2.53",    0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "I", "192.36.148.17",  0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "J", "192.58.128.30",    0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "K", "193.0.14.129",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "L", "198.32.64.12",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "M", "202.12.27.33",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
};

/* list of ccTLD servers (removed duplicated addresses) */
struct server cctldservers[] = {
	{ "NA", "128.250.1.21",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NA", "128.102.18.31",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NA", "193.0.0.193",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NA", "204.152.184.64",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NA", "204.152.184.96",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KY", "63.251.131.146",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KY", "63.251.213.226",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KY", "63.251.131.147",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LR", "146.231.128.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LR", "147.28.0.39",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KZ", "198.6.1.65",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KZ", "193.124.22.65",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KZ", "194.226.128.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KZ", "193.124.83.69",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KZ", "194.87.112.4",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KZ", "212.13.167.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KZ", "209.235.192.102",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NC", "193.50.53.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NC", "195.83.14.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MK", "193.2.1.66",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MK", "194.149.131.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MK", "193.171.255.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MK", "130.130.64.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LS", "146.230.192.18",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LS", "147.28.0.34",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ML", "205.177.10.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ML", "208.144.230.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ML", "208.144.230.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ML", "165.231.1.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ML", "208.144.230.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ML", "165.231.1.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LT", "128.214.4.29",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LT", "193.219.32.13",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LT", "158.38.0.181",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LT", "194.176.32.129",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LT", "192.36.125.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LT", "137.39.1.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NE", "194.51.3.49",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NE", "193.251.228.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MM", "194.176.93.5",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MM", "195.97.240.5",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LU", "130.59.211.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LU", "128.112.129.15",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LU", "158.64.229.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LU", "194.246.96.193",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LU", "204.74.112.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LU", "204.74.113.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LV", "159.148.60.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LV", "159.148.108.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ZW", "192.16.202.11",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ZW", "204.59.1.222",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ZW", "204.59.64.222",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ZW", "194.133.122.47",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NF", "203.12.249.101",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NF", "203.12.249.100",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NF", "203.109.252.8",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NF", "64.42.232.202",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MN", "192.82.108.38",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MN", "202.131.0.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MO", "161.64.7.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MO", "161.64.7.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MO", "137.189.6.21",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MO", "161.64.3.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MO", "161.64.3.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MO", "161.64.7.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MP", "202.128.29.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MP", "202.128.29.135",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NI", "192.94.207.66",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NI", "163.178.8.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NI", "165.98.1.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NI", "205.218.253.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MQ", "194.179.87.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MQ", "213.16.1.106",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MQ", "194.143.196.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MQ", "194.143.202.202",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MQ", "195.76.178.5",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LY", "198.6.1.82",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LY", "212.67.202.220",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MR", "193.251.145.155",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MR", "193.251.145.154",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MS", "195.153.6.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MS", "154.32.105.34",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MS", "216.21.235.214",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NL", "192.93.0.4",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NL", "193.176.144.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NL", "193.176.144.130",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MT", "192.106.1.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MT", "193.188.47.252",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MT", "193.188.34.241",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AC", "194.205.62.120",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AC", "210.141.111.69",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AC", "194.6.79.4",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AC", "210.146.53.19",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MU", "196.7.0.137",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AD", "194.158.64.7",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AD", "194.158.64.8",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AD", "194.65.3.21",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AD", "194.158.64.9",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AD", "194.158.64.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MV", "202.1.192.196",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MV", "192.23.90.196",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AE", "195.229.0.186",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AE", "213.42.0.226",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NO", "129.240.64.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NO", "129.240.2.40",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NO", "192.36.144.116",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NO", "198.133.199.105",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NO", "198.133.199.104",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MW", "209.198.244.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MW", "209.198.248.226",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MW", "216.226.222.62",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MW", "62.192.133.226",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MW", "216.252.252.5",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MW", "193.220.12.148",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AF", "212.53.85.88",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AF", "212.53.85.106",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NP", "203.37.255.97",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NP", "192.189.54.17",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NP", "202.52.255.5",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MX", "200.33.213.66",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MX", "200.33.146.213",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MX", "200.23.1.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MX", "132.248.253.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AG", "208.255.124.46",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AG", "208.255.124.36",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AG", "212.53.77.28",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AG", "212.53.64.60",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AG", "136.145.1.4",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PA", "206.228.179.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PA", "208.31.111.22",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PA", "144.228.255.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PA", "168.77.8.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PA", "208.141.92.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MY", "192.134.0.49",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MY", "161.142.227.17",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MY", "192.228.180.5",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MY", "192.228.180.6",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MY", "61.6.38.139",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NR", "203.98.224.66",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NR", "139.130.4.5",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MZ", "196.3.96.66",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MZ", "204.70.57.242",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MZ", "196.3.96.69",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MZ", "128.223.32.35",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MZ", "196.3.96.67",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AI", "209.68.1.11",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AI", "209.88.68.34",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AI", "66.187.233.210",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BA", "198.6.1.83",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BA", "195.130.35.5",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BA", "195.130.35.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BB", "205.214.192.201",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BB", "205.214.192.202",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BD", "209.58.24.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BD", "209.58.24.5",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PE", "209.45.127.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PE", "161.132.5.14",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "OM", "192.0.34.126",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "OM", "212.72.1.186",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "OM", "212.72.23.4",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NU", "64.55.105.5",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NU", "203.97.132.66",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NU", "212.181.91.4",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NU", "216.200.116.40",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NU", "204.69.234.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NU", "204.74.101.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AL", "146.48.65.46",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PF", "202.3.225.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PF", "202.3.225.20",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AM", "195.250.64.65",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AM", "195.250.64.90",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AM", "194.67.2.97",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AM", "202.12.28.131",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BE", "134.58.40.4",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BE", "193.109.126.140",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BE", "193.91.99.21",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BE", "212.113.82.90",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BE", "213.193.157.26",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BE", "213.181.36.60",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PG", "139.130.204.4",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AN", "198.93.177.21",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AN", "200.44.117.130",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AN", "128.86.1.20",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AN", "200.44.117.129",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AN", "65.207.104.147",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BF", "199.202.55.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BF", "206.82.130.195",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BF", "192.33.151.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PH", "198.6.1.161",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AO", "193.136.7.17",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BG", "139.91.1.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BG", "192.92.129.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BG", "193.68.3.252",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "QA", "212.77.192.13",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "QA", "212.77.192.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "QA", "212.77.192.15",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BH", "193.188.97.197",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BH", "193.188.97.212",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BH", "193.188.124.227",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AQ", "198.32.4.13",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AQ", "198.32.66.12",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NZ", "202.46.161.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NZ", "202.46.160.5",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NZ", "203.97.8.250",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NZ", "203.97.40.200",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NZ", "202.27.158.34",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NZ", "204.74.113.253",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "NZ", "204.74.112.253",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CA", "192.26.210.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CA", "192.73.5.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CA", "216.168.224.206",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CA", "64.26.149.98",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CA", "129.33.164.84",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BI", "194.78.100.205",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BI", "193.121.193.238",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PK", "16.1.0.18",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PK", "16.1.0.19",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PK", "216.205.150.237",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AR", "200.16.98.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AR", "200.16.97.17",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AR", "200.10.202.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BJ", "194.51.163.253",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CC", "206.253.214.11",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CC", "206.253.214.13",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CC", "216.32.212.86",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CC", "207.82.50.166",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CC", "212.62.6.38",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CC", "64.56.164.118",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AS", "213.130.50.65",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AS", "130.94.25.65",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PL", "148.81.16.51",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PL", "212.51.192.5",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PL", "149.156.1.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PL", "194.204.152.34",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PL", "193.0.80.11",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PL", "157.25.5.30",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PL", "217.17.34.50",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PM", "192.93.0.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CD", "194.38.74.11",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AT", "193.171.255.66",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AT", "194.246.96.192",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AT", "192.76.243.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AT", "193.0.0.231",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PN", "210.54.120.113",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PN", "219.88.66.69",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AU", "128.32.136.12",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AU", "128.32.136.9",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AU", "203.202.150.20",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AU", "202.12.29.59",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AU", "202.12.28.140",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BM", "199.172.192.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BM", "199.172.192.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CF", "194.206.73.253",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BN", "195.13.10.226",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BN", "165.21.83.11",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BN", "165.21.100.11",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BN", "202.160.8.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BO", "166.114.1.40",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BO", "198.6.1.202",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AW", "206.48.100.11",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AW", "208.62.21.114",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CH", "130.59.1.80",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CH", "200.16.97.77",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CH", "194.42.48.120",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PR", "134.202.1.125",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PR", "134.202.1.120",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BR", "200.160.0.5",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BR", "200.255.253.234",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BR", "200.19.119.99",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PS", "209.176.210.197",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PS", "212.14.253.242",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PS", "212.14.242.83",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "AZ", "194.87.0.8",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CK", "130.195.5.12",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CK", "130.195.6.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CK", "202.65.32.128",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CK", "202.65.32.127",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PT", "193.136.0.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PT", "193.136.2.226",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BS", "128.8.10.14",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CL", "200.1.19.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CL", "200.27.126.126",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CL", "200.9.97.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CL", "200.10.237.14",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CL", "200.27.2.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BT", "198.6.1.182",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BT", "156.106.192.121",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BT", "202.144.128.200",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "DE", "192.76.144.16",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "DE", "194.246.96.79",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "DE", "193.171.255.34",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "DE", "193.0.0.237",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "DE", "193.159.170.187",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "DE", "62.53.3.68",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "DE", "194.246.96.49",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "DE", "210.81.13.179",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "DE", "206.65.170.100",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "DE", "167.216.196.131",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CM", "195.24.192.17",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CM", "195.24.192.34",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CM", "195.24.192.35",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CN", "159.226.1.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CN", "202.97.16.196",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CN", "202.112.0.44",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CN", "210.52.214.84",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CN", "61.145.114.118",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CN", "61.139.76.53",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BV", "193.10.252.19",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CO", "128.59.59.218",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CO", "157.253.1.13",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CO", "157.253.50.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CO", "128.122.253.92",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SA", "212.26.18.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SA", "193.209.237.29",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SA", "212.138.64.70",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PY", "200.10.228.132",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "PY", "200.10.228.133",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SB", "202.139.42.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SB", "202.139.42.4",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BY", "147.45.15.34",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BY", "193.59.201.28",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BY", "193.232.248.45",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BY", "193.232.92.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SC", "194.6.79.162",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SC", "202.84.235.33",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "DJ", "193.251.143.162",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CR", "163.178.88.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BZ", "216.220.34.99",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BZ", "216.220.62.165",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "BZ", "212.100.226.111",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "DK", "130.226.1.4",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "DK", "193.88.44.42",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "DK", "193.163.102.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "DK", "195.41.46.78",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SD", "207.153.72.193",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SD", "207.153.72.194",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "EC", "157.100.1.44",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "EC", "157.100.45.33",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "EC", "216.21.233.214",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "EC", "216.21.239.214",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SE", "130.235.20.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SE", "192.36.144.107",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SE", "192.36.133.107",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SE", "192.36.134.107",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SE", "192.36.135.107",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "EE", "192.121.251.13",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "EE", "193.40.56.245",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "DM", "206.191.159.73",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "DM", "208.0.224.114",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CU", "169.158.128.136",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CU", "204.59.144.222",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "RO", "192.92.138.35",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "RO", "192.162.16.18",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "RO", "193.230.31.225",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "RO", "194.246.96.196",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SG", "202.42.194.205",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SG", "192.169.33.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SG", "165.21.100.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CV", "193.136.192.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SH", "194.205.62.60",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "EG", "193.227.1.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "DO", "66.98.65.146",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "DO", "66.98.65.147",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SI", "130.59.1.30",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SI", "193.2.1.91",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SI", "194.246.96.195",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CX", "206.253.214.136",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CX", "206.253.214.122",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CX", "210.54.247.178",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CX", "206.191.159.222",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CY", "194.42.1.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CY", "192.35.82.50",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CY", "139.91.191.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CY", "194.177.210.210",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CY", "194.42.0.134",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SK", "192.108.130.33",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SK", "192.108.130.91",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SK", "195.12.159.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SK", "195.12.159.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "CZ", "193.85.3.130",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TD", "193.251.147.253",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SL", "144.228.254.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SL", "199.0.92.5",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SM", "193.43.2.5",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SM", "194.183.64.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SM", "194.183.64.11",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SM", "128.84.154.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "RU", "194.85.119.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "RU", "194.226.96.30",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "RU", "193.125.152.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SN", "196.1.95.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SN", "206.155.163.195",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TG", "216.113.38.70",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TG", "207.253.214.199",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TG", "199.243.212.251",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TG", "205.205.35.11",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SO", "209.68.0.85",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SO", "205.166.226.38",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SO", "65.102.83.43",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TH", "202.28.0.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TH", "192.41.170.219",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TH", "202.28.1.22",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "UA", "193.193.193.100",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "UA", "209.66.103.20",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TJ", "146.83.5.204",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TJ", "209.77.224.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TJ", "209.77.250.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SR", "200.1.157.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SR", "192.41.162.32",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SR", "192.31.80.32",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SR", "192.12.94.32",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SR", "192.26.92.32",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SR", "192.35.51.32",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SR", "192.42.93.32",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SR", "63.144.218.4",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GA", "208.148.44.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "FI", "192.67.14.16",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "FI", "193.210.18.31",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "FI", "62.248.254.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "FI", "193.229.4.44",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TK", "62.41.22.202",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TK", "195.11.245.120",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TK", "216.38.132.90",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GB", "128.16.5.32",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GB", "193.62.157.66",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "FJ", "144.120.8.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ER", "140.174.131.100",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ER", "143.127.12.135",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ER", "64.90.188.42",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "DZ", "193.194.81.45",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "DZ", "193.194.64.11",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ST", "195.178.160.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ST", "212.85.64.4",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "FK", "194.119.128.65",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "FK", "194.119.128.66",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ES", "192.94.163.152",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ES", "130.206.1.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ES", "194.69.254.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ES", "194.69.254.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TM", "194.205.62.40",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ET", "196.27.22.43",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TN", "193.95.66.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SV", "168.243.254.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SV", "216.184.96.4",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "FM", "206.49.89.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "FM", "206.49.89.4",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "FM", "198.6.1.114",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "UG", "216.250.215.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "UG", "216.129.132.179",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "UG", "212.88.97.20",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TO", "206.14.214.156",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TO", "148.59.19.11",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TO", "196.7.0.139",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TO", "206.184.59.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GF", "193.121.64.5",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GF", "195.6.144.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TP", "194.106.128.50",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GG", "195.226.128.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GG", "212.100.224.90",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "FO", "129.142.7.99",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "FO", "195.82.195.99",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "VA", "193.205.245.5",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "VA", "151.1.1.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "VA", "151.1.2.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "VA", "212.77.0.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SY", "199.202.55.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SY", "66.198.41.6",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SY", "195.22.205.163",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GH", "196.3.64.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GH", "196.3.64.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GH", "213.172.132.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TR", "144.122.199.90",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TR", "144.122.199.93",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SZ", "196.15.232.19",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "SZ", "196.15.232.21",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GI", "194.88.77.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GI", "194.164.95.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "VC", "216.40.40.20",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "VC", "207.136.98.35",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "UK", "195.66.240.130",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "UK", "154.32.105.90",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "UK", "217.79.164.131",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "FR", "128.105.2.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "FR", "193.51.208.13",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "FR", "193.176.144.6",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TT", "66.27.54.138",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "VE", "150.188.4.212",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "VE", "150.185.130.16",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "VE", "150.188.4.210",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "UM", "128.9.128.127",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "UM", "128.9.176.32",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GL", "194.177.232.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GL", "194.177.224.7",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TV", "65.201.175.136",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TV", "208.184.1.167",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TV", "208.185.237.100",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TV", "64.56.165.153",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TV", "64.69.172.153",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GM", "63.77.152.177",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GM", "212.60.69.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GM", "195.225.3.100",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TW", "192.83.166.11",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TW", "210.200.137.93",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TW", "203.73.24.8",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TW", "168.95.192.9",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TW", "159.226.6.178",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "TW", "140.111.1.4",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "VI", "202.30.50.51",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "VI", "207.102.129.72",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "VI", "207.102.129.71",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GP", "193.218.114.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GP", "193.251.160.222",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GQ", "193.251.153.78",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "US", "209.173.53.162",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "US", "209.173.57.162",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "US", "209.173.60.65",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GR", "195.130.89.210",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GR", "139.91.151.70",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GR", "194.246.96.199",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GR", "192.0.34.138",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "HK", "137.189.6.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "HK", "202.112.0.34",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ID", "202.155.30.227",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ID", "202.46.64.38",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GT", "205.161.188.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GT", "168.234.68.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GT", "168.234.70.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "VN", "150.203.224.24",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "VN", "203.162.3.235",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "VN", "203.162.57.105",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "VN", "203.162.87.66",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IE", "212.17.32.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IE", "193.1.142.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IE", "192.111.39.100",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IE", "198.133.199.102",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IE", "198.133.199.103",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "HM", "208.160.157.100",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "HM", "208.160.157.101",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "HM", "202.169.102.24",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GU", "168.123.4.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GU", "168.123.2.50",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "HN", "206.48.104.142",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GW", "194.65.3.20",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "GW", "194.65.87.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "UY", "164.73.128.5",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "UZ", "194.67.52.42",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "UZ", "213.68.88.11",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "HR", "161.53.3.7",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "VU", "202.80.32.5",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "VU", "202.80.32.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "VU", "206.14.214.155",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "VU", "202.80.32.7",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IL", "128.139.34.240",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IL", "194.246.96.124",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IL", "128.139.6.66",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "HT", "206.152.15.34",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "HT", "206.152.15.33",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IM", "217.23.163.131",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IM", "194.72.6.51",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IM", "193.63.94.25",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IM", "217.23.163.130",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "HU", "193.6.27.62",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "HU", "193.225.86.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IN", "202.141.150.18",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IN", "202.41.110.66",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IO", "194.205.62.100",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IQ", "208.21.175.13",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IQ", "63.175.195.20",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "WS", "216.35.187.250",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "WS", "216.52.234.99",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "WS", "216.52.234.102",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "WS", "216.35.188.8",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "WS", "202.4.48.217",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IR", "194.225.70.83",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IR", "193.171.255.77",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IS", "193.4.58.51",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IS", "130.208.16.20",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "YE", "158.43.129.89",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "YE", "158.43.193.89",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "YE", "195.94.0.34",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "YE", "195.94.0.35",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IT", "194.119.192.34",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IT", "38.8.50.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IT", "131.154.1.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IT", "192.106.1.31",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "IT", "217.29.76.4",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "JM", "200.9.115.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "JM", "196.2.1.6",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KG", "195.38.160.36",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "JO", "193.188.66.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "JO", "193.188.66.103",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ZA", "137.214.80.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ZA", "137.158.128.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KH", "203.189.128.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KH", "203.223.32.21",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KH", "203.144.65.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "JP", "165.76.0.98",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "JP", "150.100.2.3",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "JP", "203.178.136.63",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "JP", "202.232.2.34",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "JP", "202.12.30.131",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "JP", "61.120.151.100",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KI", "202.6.120.10",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LB", "128.196.128.233",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KM", "193.251.136.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MA", "206.103.26.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MA", "212.217.0.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MA", "212.217.0.12",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MA", "212.217.1.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KR", "202.30.50.50",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KR", "134.75.30.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KR", "203.248.240.141",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KR", "211.216.50.130",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KR", "211.47.45.22",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KR", "203.255.234.103",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MC", "195.78.6.131",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LK", "128.10.2.5",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "LK", "192.248.1.65",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "ZM", "208.224.176.40",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "YU", "195.250.98.5",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "YU", "195.178.32.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "YU", "147.91.8.6",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MD", "216.154.202.22",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MD", "192.162.16.21",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MD", "216.154.202.21",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MD", "212.0.205.5",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MD", "64.81.80.74",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MD", "216.154.202.23",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KW", "161.252.48.140",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KW", "196.1.69.98",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "KW", "161.252.48.150",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MG", "194.214.107.253",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MG", "194.214.107.1",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MH", "204.95.160.2",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
	{ "MH", "204.95.160.4",   0, 0, 0, { 0 }, { 0 }, { '\0' }, { 0, 0}, },
};
