# MD028 - No blank lines inside blockquote

Aliases: `no-blanks-blockquote`

## What this rule does

Flags blank lines that appear between consecutive blockquotes when there is no other content separating them. This prevents parser ambiguity where some Markdown processors treat consecutive
blockquotes separated only by blank lines as a single blockquote, while others treat them as separate blockquotes.

## Why this matters

- **Parser ambiguity**: Different Markdown parsers handle blank lines between blockquotes inconsistently
- **Intent clarity**: It's unclear whether the author intended one blockquote or two
- **Consistency**: Encourages explicit syntax that renders predictably across all parsers

According to the CommonMark spec (Example 242), a blank line without `>` markers creates separate blockquotes. However, not all parsers follow this spec strictly, creating inconsistent rendering in
practice.

## Examples

### ✅ Correct - Single blockquote with paragraph break

```markdown
> This is a continuous quote
> with multiple lines.
>
> This is a second paragraph in the same blockquote.
> Note the > on the blank line above.
```

### ✅ Correct - Separate blockquotes with intervening content

```markdown
> First blockquote from Alice.

Then Bob responded:

> Second blockquote from Bob.
```

### ❌ Incorrect - Ambiguous consecutive blockquotes

<!-- rumdl-disable MD028 -->

```markdown
> First blockquote.

> Second blockquote.
```

The blank line between these blockquotes is ambiguous:

- CommonMark spec says these are two separate blockquotes
- Some parsers treat them as one blockquote
- The author's intent is unclear

<!-- rumdl-enable MD028 -->

### 🔧 How to fix

**Option 1:** If they should be one blockquote, add `>` on the blank line:

```markdown
> First paragraph.
>
> Second paragraph in same blockquote.
```

**Option 2:** If they should be separate, add content between them:

```markdown
> First blockquote.

And then someone else said:

> Second blockquote.
```

**Option 3:** If you intentionally want separate blockquotes without intervening content, disable this rule for your project.

## Configuration

This rule has no configuration options.

## Automatic fixes

When you run `rumdl check --fix` (or `rumdl fmt`), blank lines between consecutive blockquotes are automatically converted to lines with `>` markers, treating them as a single blockquote:

```markdown
# Before fix
> First line

> Second line

# After fix
> First line
>
> Second line
```

**Note:** The automatic fix assumes you want one blockquote. If you actually wanted two separate blockquotes, you'll need to manually add content between them or disable this rule.

## Learn more

- [CommonMark block quotes](https://spec.commonmark.org/0.31.2/#block-quotes) - Technical specification (Example 242 shows blank lines separate blockquotes)
- [Quote paragraphs](https://www.markdownguide.org/basic-syntax/#blockquotes-with-multiple-paragraphs) - How to create multi-paragraph quotes
- [markdownlint MD028](https://github.com/DavidAnson/markdownlint/blob/main/doc/md028.md) - Original rule documentation
- [markdownlint issue #263](https://github.com/DavidAnson/markdownlint/issues/263) - Discussion about the ambiguity this rule addresses

## Related rules

- [MD027](md027.md) - No multiple spaces after quote marker
- [MD009](md009.md) - No trailing spaces
- [MD012](md012.md) - No multiple consecutive blank lines
