# MD018 - No missing space after hash in heading

Aliases: `no-missing-space-atx`

## What this rule does

Ensures there's a space between the # symbols and the heading text.

## Why this matters

- **Readability**: Headings without spaces look cramped and are harder to read
- **Compatibility**: Some Markdown processors won't recognize headings without spaces
- **Standards**: Proper spacing follows Markdown best practices

## Examples

### ✅ Correct

```markdown
# Heading 1
## Heading 2
### Heading 3
#### Heading 4
##### Heading 5
###### Heading 6
```

### ❌ Incorrect

<!-- rumdl-disable MD018 -->

```markdown
#Heading 1
##Heading 2
###Heading 3
####Heading 4
#####Heading 5
######Heading 6
```

<!-- rumdl-enable MD018 -->

### 🔧 Fixed

```markdown
# Heading 1
## Heading 2
### Heading 3
#### Heading 4
##### Heading 5
###### Heading 6
```

## Configuration

This rule has no configuration options.

## Special cases

This rule correctly handles:

- Emoji hashtags like #️⃣ and #⃣ (not treated as headings)
- Regular hashtags like #tag or #123 (not treated as headings)
- Only actual heading syntax triggers this rule

## Automatic fixes

This rule automatically adds a space after the # symbols to properly format the heading.

## Learn more

- [CommonMark specification for headings](https://spec.commonmark.org/0.31.2/#atx-headings) - Technical details about heading syntax

## Related rules

- [MD019](md019.md) - No multiple spaces after hash in heading
- [MD020](md020.md) - No missing space in closed heading
- [MD021](md021.md) - No multiple spaces in closed heading
- [MD022](md022.md) - Headings should be surrounded by blank lines
